<%@page import="com.gridnine.xtrip.common.Environment"%>
<%@ page import="com.gridnine.xtrip.common.meta.rest.*" %>
<%@ page import="java.util.*" %>
<%@ page import="com.gridnine.xtrip.common.util.TextUtil" %>
<%@ page import="com.gridnine.xtrip.server.web.locale.WebLocaleHelper" %>
<%@ page language="java" session="false"
	contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ include file="common.jspf"%>
<%
    RestService currentService = Environment
        .getPublished(RestMetaRegistry.class).getServices()
        .get(request.getParameter("s"));
    if (currentService == null) {
        response.sendError(response.SC_NOT_FOUND);
        return;
    }
    RestServicePage currentPage = null;
    RestServiceOperation currentOperation = null;
	Locale locale = null;
	{
		final String l = request.getParameter("l");
		if (TextUtil.nonBlank(l)) {
			locale = WebLocaleHelper.constructLocale(l);
		}
	}
	String lang = locale != null ? locale.getLanguage() : null;
%><!DOCTYPE html>
<html>
<head>
<title><%=RestMetaRegistryHelper.joinStrings(" ", currentService.getTitle(), lang)%></title>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<link rel="stylesheet" type="text/css" href="lib/bootstrap.css" />
<link rel="stylesheet" type="text/css" href="lib/style.css" />
</head>
<body style="padding-top: 10px">
	<div class="container-fluid">
		<div class="row-fluid">
			<div class="span3">
				<%@ include file="left.jspf"%>
			</div>
			<div class="span9">
				<!-- content start -->
				<h1><%=RestMetaRegistryHelper.joinStrings(" ", currentService.getTitle(), lang)%><br> <small><%=currentService.getPath()%>/*</small>
				</h1>
				<%
				    if (currentService.isDeprecated()) {
				%>
				<p style="color: red">Сервис устарел и не рекомендуется к
					использованию.</p>
				<%
				    }
				    for (String doc : RestMetaRegistryHelper.getStrings(currentService.getDocumentation(), locale != null ? locale.getLanguage() : null)) {
				%>
				<p><%=doc%></p>
				<%
				    }
				%>
				<!-- content end -->
			</div>
		</div>
	</div>
</body>
</html>
