<%@ page
	isErrorPage="true"
%>
<%!
private String getStackTrace(Throwable t) {
    if (t == null) {
        return "n/a";
    }
	StringBuffer result = new StringBuffer();
	StackTraceElement[] els = t.getStackTrace();
	for (int i = 0; i < els.length; i++) {
		result.append("    ").append(els[i].toString() + "\r\n");
	}
	if (t.getCause() != null) {
		result.append("\r\nCaused by:\r\n")
			.append(getStackTrace(t.getCause()));
	}
	return result.toString();
}
%>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">

<html>
<head>
	<title>Error - <%= application.getServletContextName() %></title>
	<meta http-equiv="Content-Type" content="text/html; charset=<%= response.getCharacterEncoding() %>">
	<link rel="StyleSheet" type="text/css" href="resources/base.css">
</head>

<body>

<script type="text/javascript">
function toggleDetails(theForm) {
	if (theForm.details.style.display == "none") {
		theForm.details.style.display = "block";
		theForm.toggleDetailsBtn.value = "Details <<";
	} else {
		theForm.details.style.display = "none";
		theForm.toggleDetailsBtn.value = "Details >>";
	}
}
</script>

<h3>An error has occured</h3>
<p>
	<strong>Class: </strong><%= (exception == null) ? "n/a" : exception.getClass().getName() %>
	<br>
	<strong>Message: </strong><%= (exception == null) ? "n/a" : exception.getMessage() %>
</p>
<form action="#" onsubmit="toggleDetails(this); return false;">
<p>
	<input type="submit" name="toggleDetailsBtn" value="Details &gt;&gt;"><br />
	<textarea name="details" style="display:none; width:100%;height:80%" cols="50" rows="10" wrap="off"><%= "Stack trace:\r\n" + getStackTrace(exception) %></textarea>
</p>
</form>
<br><br>

</body>
</html>
