<%@ page contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"
    import="com.gridnine.xtrip.server.gracefulstop.GracefulStop"
    import="com.gridnine.xtrip.common.Environment"
	import="java.io.File"
    import="org.slf4j.LoggerFactory"
%><%
    try {
        final long time = System.currentTimeMillis();
        final String sign;
        if (request.getParameter("xml") == null) {
            sign = GracefulStop.get().getHealthSign(request.getParameter("update") != null);
        } else {
            sign = GracefulStop.get().getXmlHealthSign();
        }
        try {
            Long.parseLong(sign);
            out.println(sign);
        } catch (NumberFormatException t) {
            response.sendError(500, sign);
        } finally {
            LoggerFactory.getLogger("health").debug("health check sign=" + sign + ", time=" + Long.toString(System.currentTimeMillis() - time));
        }
    } catch (Throwable t) {
        LoggerFactory.getLogger("health").error("health check error", t);
        throw t;
    }
%>
