<%@page import="java.io.OutputStream"%>
<%@page import="java.io.FileOutputStream"%>
<%@page import="java.io.FileInputStream"%>
<%@page import="java.io.InputStream"%>
<%@page import="com.gridnine.xtrip.common.util.MiscUtil"%>
<%@page import="org.apache.commons.lang.SerializationUtils"%>
<%@page import="org.apache.commons.lang.ObjectUtils"%>
<%@page import="com.gridnine.xtrip.common.util.Base64"%>
<%@page import="java.security.MessageDigest"%>
<%@page import="com.gridnine.xtrip.common.util.TextUtil"%>
<%@page import="javax.net.ssl.SSLException"%>
<%@page import="javax.net.ssl.SSLSocket"%>
<%@page import="javax.net.ssl.SSLSocketFactory"%>
<%@page import="javax.net.ssl.TrustManager"%>
<%@page import="java.security.cert.CertificateException"%>
<%@page import="java.security.cert.X509Certificate"%>
<%@page import="javax.net.ssl.X509TrustManager"%>
<%@page import="javax.net.ssl.TrustManagerFactory"%>
<%@page import="javax.net.ssl.SSLContext"%>
<%@page import="java.security.KeyStore"%>
<%@page import="com.gridnine.xtrip.server.ServerApplication"%>
<%@page import="com.gridnine.xtrip.common.Environment"%>
<%@page import="java.io.File"%>
<%@page import="org.apache.commons.lang.StringUtils"%>
<html>
<body>
<h1>Install Cert</h1>
<%
	if (StringUtils.isBlank(request.getParameter("selected-cert"))) {
		if (StringUtils.isBlank(request.getParameter("host"))) {%>
			<form action="install-cert.jsp">
				<p>Host*: <input name="host" /></p>
				<p>Port*: <input name="port" /></p>
				<p>Passphrase: <input name="passphrase" /></p>
				<p><input type="submit" value="Install"/></p>
			</form>
		<%} else {
			String host = request.getParameter("host");
	        int port = Integer.parseInt(request.getParameter("port"));
	        char[] passphrase = (StringUtils.isBlank(request.getParameter("passphrase")) ? "changeit" : request.getParameter("passphrase")).toCharArray();
	        KeyStore keystore = getKeyStore(request);
	        SSLContext context = SSLContext.getInstance("TLS");
	        TrustManagerFactory tmf =
	                TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
	        tmf.init(keystore);
	        X509TrustManager defaultTrustManager = (X509TrustManager) tmf.getTrustManagers()[0];
	        SavingTrustManager tm = new SavingTrustManager(defaultTrustManager);
	        context.init(null, new TrustManager[]{tm}, null);
	        SSLSocketFactory factory = context.getSocketFactory();
	        %><p>Opening connection to <%=host%>:<%=port%>...</p><%
	        SSLSocket socket = (SSLSocket) factory.createSocket(host, port);
	        try {
		        socket.setSoTimeout(10000);
		        try {
			        %><p>Starting SSL handshake...</p><%
			        socket.startHandshake();
			        socket.close();
			        %><p></p><%
			        %><p>No errors, certificate is already trusted</p><%
			        return;
		        } catch (SSLException e) {
		        	%><p></p><%
		        	%><p>Certificate is not trusted</p><%
		        }
		        X509Certificate[] chain = tm.chain;
		        if (chain == null) {
		        	%><p>Could not obtain server certificate chain</p><%
		            return;
		        }
		        %><p></p><%
		        %><p>Server sent <%=chain.length %> certificate(s):</p><%
		        %><p></p><%
		        %><form action="install-cert.jsp">
		        <input type="hidden" name="host" value="<%=host%>" />
		        <input type="hidden" name="port" value="<%=port%>" />
		        <p>Select certificate to be installed:</p>
		        <select name="selected-cert">
		        <%
		        for (int i = 0; i < chain.length; i++) {
		            X509Certificate cert = chain[i];
		            %>
		            <option value="<%=Base64.encode(SerializationUtils.serialize(cert))%>">Subject <%=cert.getSubjectDN()%> / Issuer <%=cert.getIssuerDN()%></option>
		            <%
		        }
		        %></select>
		        <p><input type="submit" value="Install"/></p>
		        </form><%
	        } finally {
	        	socket.close();
	        }
		}
	} else {
		%><p>Installing certificate...</p><%
    	X509Certificate cert = (X509Certificate) SerializationUtils.deserialize(Base64.decode(request.getParameter("selected-cert")));
    	String alias = request.getParameter("host") + "-" + MiscUtil.getTimestamp();
    	KeyStore ks = getKeyStore(request);
        ks.setCertificateEntry(alias, cert);
        persistKeyStore(request, ks);
        %><p>Certificate installed successfully</p><%
	}
%>
</body>
</html>
<%!

private static char[] getPassphrase(HttpServletRequest request) {
	return (StringUtils.isBlank(request.getParameter("passphrase")) ? "changeit" : request.getParameter("passphrase")).toCharArray();
}

private static File getKeyStoreFile() {
	File file = new File("jssecacerts");
    if (file.isFile() == false) {
        char SEP = File.separatorChar;
        File dir = new File(System.getProperty("java.home") + SEP
                + "lib" + SEP + "security");
        file = new File(dir, "jssecacerts");
        if (file.isFile() == false) {
            file = new File(dir, "cacerts");
        }
    }
    return file;
}

private static KeyStore getKeyStore(HttpServletRequest request) throws Exception {
	
	char[] passphrase = getPassphrase(request);
    InputStream in = new FileInputStream(getKeyStoreFile());
    try {
	    KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
	    ks.load(in, passphrase);
	    return ks;
    } finally {
	    in.close();
    }
}

private static void persistKeyStore(HttpServletRequest request, KeyStore ks) throws Exception {
	char[] passphrase = getPassphrase(request);
	OutputStream os = new FileOutputStream(getKeyStoreFile());
    try {
	    ks.store(os, passphrase);
    } finally {
	    os.close();
    }
}

private static class SavingTrustManager implements X509TrustManager {

    private final X509TrustManager tm;
    private X509Certificate[] chain;

    SavingTrustManager(X509TrustManager tm) {
        this.tm = tm;
    }

    public X509Certificate[] getAcceptedIssuers() {
    	return new X509Certificate[0];
    }

    public void checkClientTrusted(X509Certificate[] chain, String authType)
            throws CertificateException {
        throw new UnsupportedOperationException();
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType)
            throws CertificateException {
        this.chain = chain;
        tm.checkServerTrusted(chain, authType);
    }
}
%>