<%@page import="java.util.Comparator"%>
<%@page import="java.util.Collections"%>
<%@page import="java.util.List"%>
<%@page import="com.gridnine.xtrip.common.model.system.NamedValue"%>
<%@page
	import="com.gridnine.xtrip.common.model.system.ScheduledTaskSettings"%>
<%@page import="com.gridnine.xtrip.common.util.TextUtil"%>
<%@page import="com.gridnine.xtrip.common.util.MiscUtil"%>
<%@page import="com.gridnine.xtrip.server.ScheduledTasksMonitor"%>
<%@page import="java.util.Map"%>
<%@page import="org.quartz.SimpleTrigger"%>
<%@page import="java.util.Date"%>
<%@page import="java.text.SimpleDateFormat"%>
<%@page import="java.text.DateFormat"%>
<%@page import="org.quartz.impl.SchedulerRepository"%>
<%@page import="org.quartz.TriggerKey"%>
<%@page import="org.quartz.impl.matchers.GroupMatcher"%>
<%@page import="java.lang.reflect.Field"%>
<%@page import="com.gridnine.xtrip.server.scheduler.SchedulerService"%>
<%@page import="com.gridnine.xtrip.server.ServerApplication"%>
<%@page import="com.gridnine.xtrip.common.Environment"%>
<%@page import="org.quartz.CronTrigger"%>
<%@page import="org.quartz.Trigger"%>
<%@page import="org.quartz.utils.DirtyFlagMap"%>
<%@page import="org.quartz.JobDetail"%>
<%@page import="java.net.URLEncoder"%>
<%@page import="org.quartz.Scheduler"%><%@ page language="java"
	errorPage="../error.jsp" pageEncoding="UTF-8"
	contentType="text/html; charset=UTF-8" import="java.io.*"%>
<%!private static String format(Date date, DateFormat df) {
        return date == null ? "n/a" : df.format(date);
    }

    private static String time(long millis) {
        if (millis < 1000) {
            return millis + "&nbsp;ms";
        }
        if (millis < 1000 * 60) {
            return (millis / 1000) + "&nbsp;sec";
        }
        return (millis / 1000 / 60) + "&nbsp;min";
    }

    private static String getState(ScheduledTasksMonitor.ScheduledTaskInfo info) {
        if (info.getScheduled() == null && info.getUnscheduled() == null) {
            return "not scheduled";
        }
        if (info.getLastExecutionStarted() == null
            || info.getLastExecutionFinished() == null) {
            return "ready";
        }
        return MiscUtil.compare(info.getLastExecutionFinished(),
            info.getLastExecutionStarted()) >= 0 ? "ready" : "running";
    }%>
<%
    DateFormat dtf = new SimpleDateFormat("yyyy-MM-dd'&nbsp;'HH:mm:ss");
%>
<!DOCTYPE html>
<html>
<head>
<title>Midoffice Web - Scheduled Tasks Info</title>
<link rel="StyleSheet" type="text/css" href="../resources/base.css">
<script type="text/javascript" src="../resources/lib.js"></script>
</head>
<body>
	<%
	    String key = request.getParameter("key");
	    if (!TextUtil.isBlank(key)) {
	%>
	<h1>Task details</h1>
	<%
	    ScheduledTasksMonitor.ScheduledTaskInfo info = ScheduledTasksMonitor
	            .getTaskInfo(key);
	        if (info == null) {
	%>
	<p>
		Task info not found for key:
		<%=key%></p>
	<%
	    } else {
	            ScheduledTaskSettings settings = info.getSettings();
	            if (settings != null) {
	%>
	<h3>
		<a href="javascript:toggleVisible('settings')">Task Settings</a>
	</h3>
	<dl id="settings" style="display: none;">
		<dt>Name</dt>
		<dd><%=settings.getName()%></dd>
		<dt>Installation ID</dt>
		<dd><%=TextUtil.isBlank(settings.getInstallationId()) ? "n/a"
                            : settings.getInstallationId()%></dd>
		<dt>Enabled</dt>
		<dd><%=settings.isEnabled()%></dd>
		<dt>Local</dt>
		<dd><%=settings.isLocal()%></dd>
		<dt>Job class</dt>
		<dd><%=settings.getJobClass()%></dd>
		<dt>Delay</dt>
		<dd><%=settings.getDelay() == null ? "n/a"
                            : time(settings.getDelay().longValue())%></dd>
		<dt>Period</dt>
		<dd><%=settings.getPeriod() == null ? "n/a"
                            : time(settings.getPeriod().longValue())%></dd>
		<dt>Cron</dt>
		<dd><%=TextUtil.isBlank(settings.getCron()) ? "n/a"
                            : settings.getCron()%></dd>
		<dt>Parameters</dt>
		<dd>
			<table border="1" cellspacing="0" cellpadding="5">
				<%
				    for (NamedValue nv : settings.getDataMap()) {
				%>
				<tr>
					<td><%=nv.getName()%></td>
					<td><%=nv.getValue()%></td>
				</tr>
				<%
				    }
				%>
			</table>
		</dd>
	</dl>
	<%
	    }
	%>
	<h3>
		<a href="javascript:toggleVisible('monitoring')">Task Monitoring
			Data</a>
	</h3>
	<dl id="monitoring" style="display: block;">
		<dt>Installation ID</dt>
		<dd><%=info.getInstallationId()%></dd>
		<dt>Scheduled</dt>
		<dd><%=format(info.getScheduled(), dtf)%><%=info.getScheduledInstallationId() == null ? ""
                        : " on " + info.getScheduledInstallationId()%></dd>
		<dt>Unscheduled</dt>
		<dd><%=format(info.getUnscheduled(), dtf)%><%=info.getUnscheduledInstallationId() == null ? ""
                        : " on " + info.getUnscheduledInstallationId()%></dd>
		<dt>Last executed on</dt>
		<dd><%=info.getLastExecutionInstallationId()%></dd>
		<dt>Last execution started</dt>
		<dd><%=format(info.getLastExecutionStarted(), dtf)%></dd>
		<dt>Last execution finished</dt>
		<dd><%=format(info.getLastExecutionFinished(), dtf)%>,
			<%=MiscUtil.compare(info.getLastExecutionStarted(),
                        info.getLastExecutionFinished()) >= 0 ? "now running"
                        : "duration "
                            + time(info.getLastExecutionFinished().getTime()
                                - info.getLastExecutionStarted().getTime())%>
		</dd>
		<dt>Last error on</dt>
		<dd><%=info.getLastErrorInstallationId() == null ? "n/a"
                        : info.getLastErrorInstallationId()%></dd>
		<dt>Last error date</dt>
		<dd><%=format(info.getLastErrorDate(), dtf)%></dd>
		<dt>Last error</dt>
		<dd><%=info.getLastError() == null ? "n/a" : TextUtil
                        .getExceptionStackTrace(info.getLastError())
                        .replaceAll("\\n", "<br>")
                        .replaceAll("\\t", "&nbsp;&nbsp;&nbsp;&nbsp;")
                        .replaceAll("\\s", "&nbsp;")%></dd>
	</dl>
	<%
	    Trigger trigger = info.getTrigger();
	            if (trigger != null) {
	%>
	<h3>
		<a href="javascript:toggleVisible('quartz')">Local Quartz Runtime
			Data</a>
	</h3>
	<dl id="quartz" style="display: none;">
		<dt>Prev. fire time</dt>
		<dd><%=format(trigger.getPreviousFireTime(), dtf)%></dd>
		<dt>Next fire time</dt>
		<dd><%=format(trigger.getNextFireTime(), dtf)%></dd>
		<dt>Schedule</dt>
		<dd>
			<%
			    if (trigger instanceof CronTrigger) {
			                    out.write(((CronTrigger) trigger)
			                        .getCronExpression());
			                } else if (trigger instanceof SimpleTrigger) {
			                    out.write("every&nbsp;"
			                        + time(((SimpleTrigger) trigger)
			                            .getRepeatInterval()));
			                } else {
			                    out.write("&nbsp;");
			                }
			%>
		</dd>
	</dl>
	<%
	    }
	        }
	    }
	    List<ScheduledTasksMonitor.ScheduledTaskInfo> infos = ScheduledTasksMonitor
	        .getTasksInfo();
	    Collections.sort(infos,
	        new Comparator<ScheduledTasksMonitor.ScheduledTaskInfo>() {
	            public int compare(
	                ScheduledTasksMonitor.ScheduledTaskInfo info1,
	                ScheduledTasksMonitor.ScheduledTaskInfo info2) {
	                return TextUtil.compare(info1.getName(),
	                    info2.getName(), true, true);
	            }
	        });
	%>
	<h1>
		Scheduled Tasks List [<%=infos.size()%>]
	</h1>
	<table border="1" cellspacing="0" cellpadding="5" width="99%">
		<tr>
			<th><%=TextUtil.isBlank(key) ? "&nbsp;"
                : "<a href=\"scheduled-tasks.jsp\">&#8920;</a>"%></th>
			<th>State</th>
			<th>Scope</th>
			<th>Name</th>
			<th>Schedule</th>
			<th title="According to Quartz runtime data">Prev.&nbsp;Fire</th>
			<th title="According to Quartz runtime data">Next&nbsp;Fire</th>
		</tr>
		<%
		    for (ScheduledTasksMonitor.ScheduledTaskInfo info : infos) {
		        Trigger trigger = info.getTrigger();
		        String color;
		        if (info.getLastError() == null) {
		            color = "black";
		        } else {
		            color = MiscUtil.compare(info.getLastExecutionFinished(),
		                info.getLastErrorDate()) <= 0 ? "red" : "orange";
		        }
		%>
		<tr>
			<td><a href="scheduled-tasks.jsp?key=<%=URLEncoder.encode(info.getKey(), "utf-8")%>">&#8921;</a></td>
			<td style="color: <%=color%>"><%=getState(info)%></td>
			<td><%=info.getInstallationId()%></td>
			<td><%=info.getName()%></td>
			<td><nobr>
					<%
					    if (info.getPeriod() != null) {
					            out.write("every " + time(info.getPeriod().longValue()));
					        } else if (info.getCron() != null) {
					            out.write(info.getCron());
					        } else {
					            out.write("&nbsp;");
					        }
					%>
				</nobr></td>
			<td><%=trigger == null ? "n/a" : format(
                    trigger.getPreviousFireTime(), dtf)%></td>
			<td><%=trigger == null ? "n/a" : format(
                    trigger.getNextFireTime(), dtf)%></td>
		</tr>
		<%
		    }
		%>
	</table>
</body>
</html>