/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.standard;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.java.plugin.util.IoUtil;

final class ShadingUtil {
    static String getExtension(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        int p = name.lastIndexOf(46);
        if (p != -1 && p > 0 && p < name.length() - 1) {
            return name.substring(p + 1);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unpack(ZipFile zipFile, File destFolder) throws IOException {
        Enumeration<? extends ZipEntry> en = zipFile.entries();
        while (en.hasMoreElements()) {
            ZipEntry entry = en.nextElement();
            String name = entry.getName();
            File entryFile = new File(destFolder.getCanonicalPath() + "/" + name);
            if (name.endsWith("/")) {
                if (!entryFile.exists() && !entryFile.mkdirs()) {
                    throw new IOException("can't create folder " + entryFile);
                }
            } else {
                File folder = entryFile.getParentFile();
                if (!folder.exists() && !folder.mkdirs()) {
                    throw new IOException("can't create folder " + folder);
                }
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(entryFile, false));
                try {
                    InputStream in = zipFile.getInputStream(entry);
                    try {
                        IoUtil.copyStream(in, out, 1024);
                    }
                    finally {
                        in.close();
                    }
                }
                finally {
                    ((OutputStream)out).close();
                }
            }
            entryFile.setLastModified(entry.getTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unpack(InputStream strm, File destFolder) throws IOException {
        ZipInputStream zipStrm = new ZipInputStream(strm);
        ZipEntry entry = zipStrm.getNextEntry();
        while (entry != null) {
            String name = entry.getName();
            File entryFile = new File(destFolder.getCanonicalPath() + "/" + name);
            if (name.endsWith("/")) {
                if (!entryFile.exists() && !entryFile.mkdirs()) {
                    throw new IOException("can't create folder " + entryFile);
                }
            } else {
                File folder = entryFile.getParentFile();
                if (!folder.exists() && !folder.mkdirs()) {
                    throw new IOException("can't create folder " + folder);
                }
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(entryFile, false));
                try {
                    IoUtil.copyStream(zipStrm, out, 1024);
                }
                finally {
                    ((OutputStream)out).close();
                }
            }
            entryFile.setLastModified(entry.getTime());
            entry = zipStrm.getNextEntry();
        }
    }

    static boolean deleteFile(File file) {
        if (file.isDirectory()) {
            IoUtil.emptyFolder(file);
        }
        return file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Date getLastModified(URL url) throws IOException {
        String urlStr;
        int p;
        long result = 0L;
        if ("jar".equalsIgnoreCase(url.getProtocol()) && (p = (urlStr = url.toExternalForm()).indexOf("!/")) != -1) {
            return ShadingUtil.getLastModified(new URL(urlStr.substring(4, p)));
        }
        File sourceFile = IoUtil.url2file(url);
        if (sourceFile != null) {
            result = sourceFile.lastModified();
        } else {
            URLConnection cnn = url.openConnection();
            try {
                cnn.setUseCaches(false);
                cnn.setDoInput(false);
                result = cnn.getLastModified();
            }
            finally {
                try {
                    cnn.getInputStream().close();
                }
                catch (IOException iOException) {}
            }
        }
        if (result == 0L) {
            throw new IOException("can't retrieve modification date for resource " + url);
        }
        Calendar cldr = Calendar.getInstance(Locale.ENGLISH);
        cldr.setTime(new Date(result));
        cldr.set(14, 0);
        return cldr.getTime();
    }

    private static String getRelativePath(File base, File file) throws IOException {
        String newPrefix;
        String basePath;
        String filePath = file.getCanonicalPath();
        if (base.isFile()) {
            File baseParent = base.getParentFile();
            if (baseParent == null) {
                return null;
            }
            basePath = baseParent.getCanonicalPath();
        } else {
            basePath = base.getCanonicalPath();
        }
        if (!basePath.endsWith(File.separator)) {
            basePath = basePath + File.separator;
        }
        int p = basePath.indexOf(File.separatorChar);
        String prefix = null;
        while (p != -1 && filePath.startsWith(newPrefix = basePath.substring(0, p + 1))) {
            prefix = newPrefix;
            p = basePath.indexOf(File.separatorChar, p + 1);
        }
        if (prefix == null) {
            return null;
        }
        filePath = filePath.substring(prefix.length());
        if (prefix.length() == basePath.length()) {
            return filePath;
        }
        int c = 0;
        p = basePath.indexOf(File.separatorChar, prefix.length());
        while (p != -1) {
            ++c;
            p = basePath.indexOf(File.separatorChar, p + 1);
        }
        for (int i = 0; i < c; ++i) {
            filePath = ".." + File.separator + filePath;
        }
        return filePath;
    }

    private static String getRelativeUrl(File base, File file) throws IOException {
        String result = ShadingUtil.getRelativePath(base, file);
        if (result == null) {
            return null;
        }
        result = result.replace('\\', '/');
        if (file.isDirectory() && !result.endsWith("/")) {
            result = result + "/";
        }
        return result;
    }

    static String getRelativeUrl(File base, URL url) throws IOException {
        String urlStr;
        int p;
        String result;
        File file = IoUtil.url2file(url);
        if (file != null && (result = ShadingUtil.getRelativeUrl(base, file)) != null) {
            String urlStr2 = url.toExternalForm();
            int p2 = urlStr2.indexOf("!/");
            if (p2 != -1) {
                return "jar:" + result + urlStr2.substring(p2);
            }
            return result;
        }
        if ("jar".equalsIgnoreCase(url.getProtocol()) && (p = (urlStr = url.toExternalForm()).indexOf("!/")) != -1) {
            return "jar:" + ShadingUtil.getRelativeUrl(base, new URL(urlStr.substring(4, p))) + urlStr.substring(p);
        }
        return url.toExternalForm();
    }

    static URL buildURL(URL base, String url) throws MalformedURLException {
        if (!url.toLowerCase(Locale.ENGLISH).startsWith("jar:")) {
            return new URL(base, url);
        }
        int p = url.indexOf("!/");
        if (p == -1) {
            return new URL(base, url.substring(4, p));
        }
        return new URL("jar:" + new URL(base, url.substring(4, p)).toExternalForm() + url.substring(p));
    }

    private ShadingUtil() {
    }
}

