/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.tools.ant;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.tools.ant.BuildException;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginFragment;
import org.java.plugin.registry.Version;
import org.java.plugin.tools.ant.BaseJpfTask;
import org.java.plugin.util.IoUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class VersionUpdateTask
extends BaseJpfTask {
    private File versionsFile;
    private boolean alterReferences = false;
    private boolean timestampVersion = false;

    public final void setAlterReferences(boolean value) {
        this.alterReferences = value;
    }

    public void setVersionsFile(File value) {
        this.versionsFile = value;
    }

    public void setTimestampVersion(boolean value) {
        this.timestampVersion = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        Transformer transformer;
        DocumentBuilder documentBuilder;
        File homeFile;
        URL homeUrl;
        File manifestFile;
        Properties versions;
        block42: {
            if (this.versionsFile == null) {
                throw new BuildException("versionsfile attribute must be set!", this.getLocation());
            }
            this.initRegistry(true);
            if (this.getVerbose()) {
                this.log("Loading versions file " + this.versionsFile);
            }
            versions = new Properties();
            if (this.versionsFile.exists()) {
                try {
                    BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.versionsFile));
                    try {
                        versions.load(in);
                        break block42;
                    }
                    finally {
                        ((InputStream)in).close();
                    }
                }
                catch (IOException ioe) {
                    throw new BuildException("failed reading versions file " + this.versionsFile, (Throwable)ioe, this.getLocation());
                }
            }
            this.log("Versions file " + this.versionsFile + " not found, new one will be created.");
        }
        HashMap<String, PluginInfo> infos = new HashMap<String, PluginInfo>();
        for (PluginDescriptor pluginDescriptor : this.getRegistry().getPluginDescriptors()) {
            manifestFile = IoUtil.url2file(pluginDescriptor.getLocation());
            if (manifestFile == null) {
                throw new BuildException("non-local plug-in manifest URL given " + pluginDescriptor.getLocation());
            }
            homeUrl = this.getPathResolver().resolvePath(pluginDescriptor, "/");
            homeFile = IoUtil.url2file(homeUrl);
            if (homeFile == null) {
                throw new BuildException("non-local plug-in home URL given " + homeUrl);
            }
            try {
                infos.put(pluginDescriptor.getId(), new PluginInfo(pluginDescriptor.getId(), versions, manifestFile, homeFile, pluginDescriptor.getVersion()));
            }
            catch (ParseException pe) {
                throw new BuildException("failed parsing versions data  for manifest " + manifestFile, (Throwable)pe, this.getLocation());
            }
            if (!this.getVerbose()) continue;
            this.log("Collected manifest file " + manifestFile);
        }
        for (PluginFragment pluginFragment : this.getRegistry().getPluginFragments()) {
            manifestFile = IoUtil.url2file(pluginFragment.getLocation());
            if (manifestFile == null) {
                throw new BuildException("non-local plug-in fragment manifest URL given " + pluginFragment.getLocation());
            }
            homeUrl = this.getPathResolver().resolvePath(pluginFragment, "/");
            homeFile = IoUtil.url2file(homeUrl);
            if (homeFile == null) {
                throw new BuildException("non-local plug-in fragment home URL given " + homeUrl);
            }
            try {
                infos.put(pluginFragment.getId(), new PluginInfo(pluginFragment.getId(), versions, manifestFile, homeFile, pluginFragment.getVersion()));
            }
            catch (ParseException pe) {
                throw new BuildException("failed parsing versions data  for manifest " + manifestFile, (Throwable)pe, this.getLocation());
            }
            if (!this.getVerbose()) continue;
            this.log("Populated manifest file " + manifestFile);
        }
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setValidating(false);
        try {
            documentBuilder = builderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            throw new BuildException("can't obtain XML document builder ", (Throwable)pce, this.getLocation());
        }
        if (this.getVerbose()) {
            this.log("Processing versions");
        }
        for (PluginInfo info : infos.values()) {
            try {
                info.processVersion(versions, documentBuilder, this.timestampVersion);
            }
            catch (Exception e) {
                throw new BuildException("failed processing manifest " + info.getManifestFile(), (Throwable)e, this.getLocation());
            }
        }
        if (this.alterReferences) {
            if (this.getVerbose()) {
                this.log("Processing version references");
            }
            for (PluginInfo info : infos.values()) {
                try {
                    info.processVersionReferences(versions, documentBuilder);
                }
                catch (Exception e) {
                    throw new BuildException("failed processing manifest " + info.getManifestFile(), (Throwable)e, this.getLocation());
                }
            }
        }
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException tce) {
            throw new BuildException("can't obtain XML document transformer ", (Throwable)tce, this.getLocation());
        }
        catch (TransformerFactoryConfigurationError tfce) {
            throw new BuildException("can't obtain XML document transformer factory ", (Throwable)tfce, this.getLocation());
        }
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("standalone", "no");
        transformer.setOutputProperty("doctype-public", "-//JPF//Java Plug-in Manifest 1.0");
        transformer.setOutputProperty("doctype-system", "http://jpf.sourceforge.net/plugin_1_0.dtd");
        if (this.getVerbose()) {
            this.log("Saving manifests");
        }
        for (PluginInfo info : infos.values()) {
            try {
                info.save(versions, transformer);
            }
            catch (Exception e) {
                throw new BuildException("failed saving manifest " + info.getManifestFile(), (Throwable)e, this.getLocation());
            }
        }
        if (this.getVerbose()) {
            this.log("Saving versions file " + this.versionsFile);
        }
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.versionsFile));
            try {
                versions.store(out, "Plug-in and plug-in fragment versions file");
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        catch (IOException ioe) {
            throw new BuildException("failed writing versions file " + this.versionsFile, (Throwable)ioe, this.getLocation());
        }
        this.log("Plug-in versions update done");
    }

    static final class PluginInfo {
        private final String id;
        private final File manifestFile;
        private final Version oldVersion;
        private final Date oldTimestamp;
        private final DateFormat dtf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
        private Document doc;
        private Version newVersion;
        private Date currentTimestamp;

        private static Date getTimestamp(File file, Date parentTimestamp) {
            Date result = parentTimestamp == null ? new Date(file.lastModified()) : new Date(Math.max(parentTimestamp.getTime(), file.lastModified()));
            File[] files = file.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    result = PluginInfo.getTimestamp(files[i], result);
                }
            }
            return result;
        }

        private static Version upgradeVersion(Version ver) {
            if (ver == null) {
                return new Version(0, 0, 1, null);
            }
            return new Version(ver.getMajor(), ver.getMinor(), ver.getBuild() + 1, ver.getName());
        }

        private static Version upgradeVersion(Version ver, Date timestamp) {
            SimpleDateFormat dtf = new SimpleDateFormat("yyyyMMddHHmmss", Locale.ENGLISH);
            if (ver == null) {
                return new Version(0, 0, 1, dtf.format(timestamp));
            }
            return new Version(ver.getMajor(), ver.getMinor(), ver.getBuild() + 1, dtf.format(timestamp));
        }

        PluginInfo(String anId, Properties versions, File aMnifestFile, File homeFile, Version currentVersion) throws ParseException {
            this.id = anId;
            String versionStr = versions.getProperty(anId, null);
            String timestampStr = versions.getProperty(anId + ".timestamp", null);
            this.oldVersion = versionStr != null ? Version.parse(versionStr) : currentVersion;
            this.oldTimestamp = timestampStr != null ? this.dtf.parse(timestampStr) : null;
            this.manifestFile = aMnifestFile;
            this.currentTimestamp = PluginInfo.getTimestamp(homeFile, null);
            versions.setProperty(this.id + ".timestamp", this.dtf.format(this.currentTimestamp));
        }

        File getManifestFile() {
            return this.manifestFile;
        }

        void processVersion(Properties versions, DocumentBuilder builder, boolean timestampVersion) throws Exception {
            this.newVersion = IoUtil.compareFileDates(this.oldTimestamp, this.currentTimestamp) ? this.oldVersion : (!timestampVersion ? PluginInfo.upgradeVersion(this.oldVersion) : PluginInfo.upgradeVersion(this.oldVersion, this.currentTimestamp));
            versions.setProperty(this.id, this.newVersion.toString());
            if (this.oldVersion.equals(this.newVersion)) {
                return;
            }
            this.doc = builder.parse(this.manifestFile);
            Element root = this.doc.getDocumentElement();
            if (root.hasAttribute("version")) {
                root.setAttribute("version", this.newVersion.toString());
            }
        }

        void processVersionReferences(Properties versions, DocumentBuilder builder) throws Exception {
            Element root;
            if (this.doc == null) {
                this.doc = builder.parse(this.manifestFile);
            }
            if ("plugin-fragment".equals((root = this.doc.getDocumentElement()).getNodeName())) {
                this.processVersionReference(versions, root);
            }
            NodeList imports = root.getElementsByTagName("import");
            for (int i = 0; i < imports.getLength(); ++i) {
                this.processVersionReference(versions, (Element)imports.item(i));
            }
        }

        private void processVersionReference(Properties versions, Element elm) {
            if (!elm.hasAttribute("plugin-version")) {
                return;
            }
            String version = versions.getProperty(elm.getAttribute("plugin-id"), this.id);
            if (version != null) {
                elm.setAttribute("plugin-version", version);
            }
        }

        void save(Properties versions, Transformer transformer) throws Exception {
            if (this.doc == null) {
                return;
            }
            long modified = this.manifestFile.lastModified();
            transformer.transform(new DOMSource(this.doc), new StreamResult(this.manifestFile));
            this.manifestFile.setLastModified(modified);
        }
    }
}

