/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.ex;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.Plugin;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.PluginLifecycleException;
import org.java.plugin.PluginManager;
import org.java.plugin.ex.IndexPluginClassLoader;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.standard.PluginLifecycleHandler;
import org.java.plugin.standard.StandardObjectFactory;
import org.java.plugin.util.ExtendedProperties;

public class EnhancedPluginLifecycleHandler
extends PluginLifecycleHandler {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    protected PluginClassLoader createPluginClassLoader(PluginDescriptor descr) {
        IndexPluginClassLoader result = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedAction<IndexPluginClassLoader>(){

            @Override
            public IndexPluginClassLoader run() {
                return new IndexPluginClassLoader(EnhancedPluginLifecycleHandler.this.getPluginManager(), ((Object)((Object)EnhancedPluginLifecycleHandler.this)).getClass().getClassLoader());
            }
        }) : new IndexPluginClassLoader(this.getPluginManager(), ((Object)((Object)this)).getClass().getClassLoader());
        return result;
    }

    protected Plugin createPluginInstance(PluginDescriptor descr) throws PluginLifecycleException {
        Class pluginClass;
        String className = descr.getPluginClassName();
        try {
            pluginClass = this.getPluginManager().getPluginClassLoader(descr).loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            throw new PluginLifecycleException(StandardObjectFactory.class.getPackage().getName(), "pluginClassNotFound", (Object)className, (Throwable)cnfe);
        }
        try {
            return (Plugin)pluginClass.newInstance();
        }
        catch (InstantiationException ie) {
            throw new PluginLifecycleException(StandardObjectFactory.class.getPackage().getName(), "pluginClassInstantiationFailed", (Object)descr.getId(), (Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            throw new PluginLifecycleException(StandardObjectFactory.class.getPackage().getName(), "pluginClassInstantiationFailed", (Object)descr.getId(), (Throwable)iae);
        }
    }

    protected void beforePluginStart(Plugin plugin) {
    }

    protected void afterPluginStop(Plugin plugin) {
    }

    protected void dispose() {
    }

    public void configure(ExtendedProperties config) {
    }

    public void init(PluginManager aManager) {
        super.init(aManager);
    }
}

