/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.registry.xml;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.StringTokenizer;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.ParameterType;
import org.java.plugin.registry.PluginRegistry;

class ParameterValueParser {
    private Object value;
    private final boolean isParsingSucceeds;
    private String parsingMessage;

    private static ExtensionPoint getExtensionPoint(PluginRegistry registry, String uniqueId) {
        String pluginId = registry.extractPluginId(uniqueId);
        if (!registry.isPluginDescriptorAvailable(pluginId)) {
            return null;
        }
        String pointId = registry.extractId(uniqueId);
        for (ExtensionPoint point : registry.getPluginDescriptor(pluginId).getExtensionPoints()) {
            if (!point.getId().equals(pointId)) continue;
            return point;
        }
        return null;
    }

    ParameterValueParser(PluginRegistry registry, ExtensionPoint.ParameterDefinition definition, String rawValue) {
        if (definition == null) {
            this.parsingMessage = "parameter definition is NULL";
            this.isParsingSucceeds = false;
            return;
        }
        if (rawValue == null) {
            this.isParsingSucceeds = true;
            return;
        }
        if (ParameterType.ANY == definition.getType() || ParameterType.NULL == definition.getType()) {
            this.isParsingSucceeds = true;
            return;
        }
        if (ParameterType.STRING == definition.getType()) {
            this.value = rawValue;
            this.isParsingSucceeds = true;
            return;
        }
        String val = rawValue.trim();
        if (val.length() == 0) {
            this.isParsingSucceeds = true;
            return;
        }
        switch (definition.getType()) {
            case BOOLEAN: {
                if ("true".equals(val)) {
                    this.value = Boolean.TRUE;
                    break;
                }
                if ("false".equals(val)) {
                    this.value = Boolean.FALSE;
                    break;
                }
                this.isParsingSucceeds = false;
                return;
            }
            case NUMBER: {
                try {
                    this.value = NumberFormat.getInstance(Locale.ENGLISH).parse(val);
                    break;
                }
                catch (ParseException nfe) {
                    this.isParsingSucceeds = false;
                    return;
                }
            }
            case DATE: {
                SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
                try {
                    this.value = fmt.parse(val);
                    break;
                }
                catch (ParseException pe) {
                    this.isParsingSucceeds = false;
                    return;
                }
            }
            case TIME: {
                SimpleDateFormat fmt = new SimpleDateFormat("HH:mm:ss", Locale.ENGLISH);
                try {
                    this.value = fmt.parse(val);
                    break;
                }
                catch (ParseException pe) {
                    this.isParsingSucceeds = false;
                    return;
                }
            }
            case DATE_TIME: {
                SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
                try {
                    this.value = fmt.parse(val);
                    break;
                }
                catch (ParseException pe) {
                    this.isParsingSucceeds = false;
                    return;
                }
            }
            case PLUGIN_ID: {
                try {
                    this.value = registry.getPluginDescriptor(val);
                    break;
                }
                catch (IllegalArgumentException iae) {
                    this.parsingMessage = "unknown plug-in ID " + val;
                    this.isParsingSucceeds = false;
                    return;
                }
            }
            case EXTENSION_POINT_ID: {
                this.value = ParameterValueParser.getExtensionPoint(registry, val);
                if (this.value == null) {
                    this.parsingMessage = "unknown extension point UID " + val;
                    this.isParsingSucceeds = false;
                    return;
                }
                if (definition.getCustomData() == null) break;
                ExtensionPoint customExtPoint = ParameterValueParser.getExtensionPoint(registry, definition.getCustomData());
                if (customExtPoint == null) {
                    this.parsingMessage = "unknown extension point UID " + definition.getCustomData() + " provided as custom data";
                    this.isParsingSucceeds = false;
                    return;
                }
                if (((ExtensionPoint)this.value).isSuccessorOf(customExtPoint)) break;
                this.parsingMessage = "extension point with UID " + val + " doesn't \"inherit\" point that is defined according to custom data in parameter definition - " + definition.getCustomData();
                this.isParsingSucceeds = false;
                return;
            }
            case EXTENSION_ID: {
                String extId = registry.extractId(val);
                for (Extension ext : registry.getPluginDescriptor(registry.extractPluginId(val)).getExtensions()) {
                    if (!ext.getId().equals(extId)) continue;
                    this.value = ext;
                    break;
                }
                if (this.value == null) {
                    this.parsingMessage = "unknown extension UID " + val;
                    this.isParsingSucceeds = false;
                    return;
                }
                if (definition.getCustomData() == null) break;
                ExtensionPoint customExtPoint = ParameterValueParser.getExtensionPoint(registry, definition.getCustomData());
                if (customExtPoint == null) {
                    this.parsingMessage = "unknown extension point UID " + definition.getCustomData() + " provided as custom data in parameter definition " + definition;
                    this.isParsingSucceeds = false;
                    return;
                }
                String extPointUid = registry.makeUniqueId(((Extension)this.value).getExtendedPluginId(), ((Extension)this.value).getExtendedPointId());
                ExtensionPoint extPoint = ParameterValueParser.getExtensionPoint(registry, extPointUid);
                if (extPoint == null) {
                    this.parsingMessage = "extension point " + extPointUid + " is unknown for extension " + ((Extension)this.value).getUniqueId();
                    this.isParsingSucceeds = false;
                    return;
                }
                if (extPoint.equals(customExtPoint) || extPoint.isSuccessorOf(customExtPoint)) break;
                this.parsingMessage = "extension with UID " + val + " extends point that not allowed according to custom data defined in parameter definition - " + definition.getCustomData();
                this.isParsingSucceeds = false;
                return;
            }
            case FIXED: {
                StringTokenizer st = new StringTokenizer(definition.getCustomData(), "|", false);
                while (st.hasMoreTokens()) {
                    if (!val.equals(st.nextToken().trim())) continue;
                    this.value = val;
                    this.isParsingSucceeds = true;
                    return;
                }
                this.parsingMessage = "not allowed value " + val;
                this.isParsingSucceeds = false;
                return;
            }
            case RESOURCE: {
                try {
                    this.value = new URL(val);
                }
                catch (MalformedURLException mue) {
                    this.parsingMessage = "can't parse value " + val + " as an absolute URL, will treat it as relative URL";
                    this.value = null;
                }
                this.isParsingSucceeds = true;
                return;
            }
            case ANY: {
                break;
            }
            case NULL: {
                break;
            }
        }
        this.isParsingSucceeds = true;
    }

    Object getValue() {
        return this.value;
    }

    String getParsingMessage() {
        return this.parsingMessage;
    }

    boolean isParsingSucceeds() {
        return this.isParsingSucceeds;
    }
}

