/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.tools.ant;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;
import org.java.plugin.ObjectFactory;
import org.java.plugin.PathResolver;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.ManifestInfo;
import org.java.plugin.registry.ManifestProcessingException;
import org.java.plugin.registry.PluginRegistry;
import org.java.plugin.util.IoUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseJpfTask
extends MatchingTask {
    private static final FileUtils fileUtils = FileUtils.newFileUtils();
    private final LinkedList<FileSet> fileSets = new LinkedList();
    private File baseDir;
    private boolean verbose;
    private PluginRegistry registry;
    private PathResolver pathResolver;
    private Set<String> whiteList;
    private Set<String> blackList;

    public void addFileset(FileSet set) {
        this.fileSets.add(set);
    }

    public final void setBaseDir(File aBaseDir) {
        this.baseDir = aBaseDir;
    }

    public final void setVerbose(boolean aVerbose) {
        this.verbose = aVerbose;
    }

    public final void setWhiteList(File file) throws IOException {
        this.whiteList = this.loadList(file);
    }

    public final void setBlackList(File file) throws IOException {
        this.blackList = this.loadList(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> loadList(File file) throws IOException {
        if (file == null) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                result.add(line);
            }
        }
        finally {
            reader.close();
        }
        return result;
    }

    protected final boolean getVerbose() {
        return this.verbose;
    }

    protected final PathResolver getPathResolver() {
        return this.pathResolver;
    }

    protected final PluginRegistry getRegistry() {
        return this.registry;
    }

    protected Set<String> getWhiteList() {
        return this.whiteList;
    }

    protected Set<String> getBlackList() {
        return this.blackList;
    }

    protected final void initRegistry(boolean usePathResolver) {
        Map<String, Identity> processedPlugins;
        if (this.baseDir != null) {
            if (!this.baseDir.isDirectory()) {
                throw new BuildException("basedir " + this.baseDir + " does not exist!", this.getLocation());
            }
        } else {
            this.baseDir = this.getProject().getBaseDir();
        }
        ObjectFactory objectFactory = ObjectFactory.newInstance();
        this.registry = objectFactory.createRegistry();
        File[] manifestFiles = this.getIncludedFiles();
        LinkedList<URL> manifestUrls = new LinkedList<URL>();
        HashMap<String, URL> foldersMap = new HashMap<String, URL>();
        for (int i = 0; i < manifestFiles.length; ++i) {
            File manifestFile = manifestFiles[i];
            try {
                URL manifestUrl = this.getManifestURL(manifestFile);
                if (manifestUrl == null) {
                    if (!this.verbose) continue;
                    this.log("Skipped file: " + manifestFile);
                    continue;
                }
                try {
                    if (!this.isManifestAccepted(manifestUrl)) {
                        if (!this.verbose) continue;
                        this.log("Skipped URL: " + manifestUrl);
                        continue;
                    }
                }
                catch (ManifestProcessingException mpe) {
                    throw new BuildException("can't read manifest from URL " + manifestUrl, (Throwable)mpe, this.getLocation());
                }
                manifestUrls.add(manifestUrl);
                if (this.verbose) {
                    this.log("Added URL: " + manifestUrl);
                }
                if (!usePathResolver) continue;
                if ("jar".equals(manifestUrl.getProtocol())) {
                    foldersMap.put(manifestUrl.toExternalForm(), IoUtil.file2url(manifestFile));
                    continue;
                }
                foldersMap.put(manifestUrl.toExternalForm(), IoUtil.file2url(manifestFile.getParentFile()));
                continue;
            }
            catch (MalformedURLException mue) {
                throw new BuildException("can't create URL for file " + manifestFile, (Throwable)mue, this.getLocation());
            }
        }
        try {
            processedPlugins = this.registry.register(manifestUrls.toArray(new URL[manifestUrls.size()]));
        }
        catch (Exception e) {
            throw new BuildException("can't register URLs", (Throwable)e, this.getLocation());
        }
        this.log("Registry initialized, registered manifests: " + processedPlugins.size() + " of " + manifestUrls.size(), processedPlugins.size() != manifestUrls.size() ? 1 : 2);
        if (usePathResolver) {
            this.pathResolver = objectFactory.createPathResolver();
            for (Map.Entry<String, Identity> entry : processedPlugins.entrySet()) {
                this.pathResolver.registerContext(entry.getValue(), (URL)foldersMap.get(entry.getKey()));
            }
            if (this.verbose) {
                this.log("Path resolver initialized");
            }
        }
    }

    protected File[] getIncludedFiles() {
        HashSet<File> result = new HashSet<File>();
        for (FileSet fs : this.fileSets) {
            for (String file : fs.getDirectoryScanner(this.getProject()).getIncludedFiles()) {
                if (file == null) continue;
                result.add(fileUtils.resolveFile(fs.getDir(this.getProject()), file));
            }
        }
        if (this.fileSets.isEmpty()) {
            for (String file : this.getDirectoryScanner(this.baseDir).getIncludedFiles()) {
                if (file == null) continue;
                result.add(fileUtils.resolveFile(this.baseDir, file));
            }
        }
        return result.toArray(new File[result.size()]);
    }

    protected URL getManifestURL(File file) throws MalformedURLException {
        if (file.getName().endsWith(".jar") || file.getName().endsWith(".zip")) {
            URL url = new URL("jar:" + IoUtil.file2url(file).toExternalForm() + "!/plugin.xml");
            if (IoUtil.isResourceExists(url)) {
                return url;
            }
            url = new URL("jar:" + IoUtil.file2url(file).toExternalForm() + "!/plugin-fragment.xml");
            if (IoUtil.isResourceExists(url)) {
                return url;
            }
            url = new URL("jar:" + IoUtil.file2url(file).toExternalForm() + "!/META-INF/plugin.xml");
            if (IoUtil.isResourceExists(url)) {
                return url;
            }
            url = new URL("jar:" + IoUtil.file2url(file).toExternalForm() + "!/META-INF/plugin-fragment.xml");
            if (IoUtil.isResourceExists(url)) {
                return url;
            }
            return null;
        }
        return IoUtil.file2url(file);
    }

    protected boolean isManifestAccepted(URL manifestUrl) throws ManifestProcessingException {
        if (this.whiteList == null && this.blackList == null) {
            return true;
        }
        ManifestInfo manifestInfo = this.registry.readManifestInfo(manifestUrl);
        if (this.whiteList != null && this.isPluginInList(manifestInfo, this.whiteList)) {
            return true;
        }
        return this.blackList == null || !this.isPluginInList(manifestInfo, this.blackList);
    }

    private boolean isPluginInList(ManifestInfo manifestInfo, Set<String> list) {
        if (list.contains(manifestInfo.getId())) {
            return true;
        }
        return list.contains(this.registry.makeUniqueId(manifestInfo.getId(), manifestInfo.getVersion()));
    }
}

