/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.tools.mocks;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import org.java.plugin.PathResolver;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.tools.mocks.MockPluginElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockParameter
extends MockPluginElement<Extension.Parameter>
implements Extension.Parameter {
    private Extension declaringExtension;
    private ExtensionPoint.ParameterDefinition definition;
    private Extension.Parameter superParameter;
    private String rawValue;
    private Object typedValue;
    private LinkedList<Extension.Parameter> subParameters = new LinkedList();

    public MockParameter() {
    }

    public MockParameter(String id, String aRawValue, Object aTypedValue) {
        this.setId(id);
        this.rawValue = aRawValue;
        this.typedValue = aTypedValue;
    }

    public MockParameter(String id, String aRawValue, Object aTypedValue, Extension aDeclaringExtension) {
        this.setId(id);
        this.rawValue = aRawValue;
        this.typedValue = aTypedValue;
        this.declaringExtension = aDeclaringExtension;
    }

    @Override
    public Extension getDeclaringExtension() {
        return this.declaringExtension;
    }

    public MockParameter setDeclaringExtension(Extension value) {
        this.declaringExtension = value;
        return this;
    }

    @Override
    public ExtensionPoint.ParameterDefinition getDefinition() {
        return this.definition;
    }

    public MockParameter setDefinition(ExtensionPoint.ParameterDefinition value) {
        this.definition = value;
        return this;
    }

    @Override
    public Extension.Parameter getSubParameter(String id) {
        for (Extension.Parameter param : this.subParameters) {
            if (!param.getId().equals(id)) continue;
            return param;
        }
        throw new IllegalArgumentException("unknown parameter ID " + id);
    }

    @Override
    public Collection<Extension.Parameter> getSubParameters() {
        return Collections.unmodifiableCollection(this.subParameters);
    }

    @Override
    public Collection<Extension.Parameter> getSubParameters(String id) {
        LinkedList<Extension.Parameter> result = new LinkedList<Extension.Parameter>();
        for (Extension.Parameter param : this.subParameters) {
            if (!param.getId().equals(id)) continue;
            result.add(param);
        }
        return result;
    }

    public MockParameter addParameter(Extension.Parameter parameter) {
        this.subParameters.add(parameter);
        return this;
    }

    @Override
    public Extension.Parameter getSuperParameter() {
        return this.superParameter;
    }

    public MockParameter setSuperParameter(Extension.Parameter value) {
        this.superParameter = value;
        return this;
    }

    @Override
    public String rawValue() {
        return this.rawValue;
    }

    public MockParameter setValue(String raw, Object typed) {
        this.rawValue = raw;
        this.typedValue = typed;
        return this;
    }

    @Override
    public Boolean valueAsBoolean() {
        return (Boolean)this.typedValue;
    }

    @Override
    public Date valueAsDate() {
        return (Date)this.typedValue;
    }

    @Override
    public Extension valueAsExtension() {
        return (Extension)this.typedValue;
    }

    @Override
    public ExtensionPoint valueAsExtensionPoint() {
        return (ExtensionPoint)this.typedValue;
    }

    @Override
    public Number valueAsNumber() {
        return (Number)this.typedValue;
    }

    @Override
    public PluginDescriptor valueAsPluginDescriptor() {
        return (PluginDescriptor)this.typedValue;
    }

    @Override
    public String valueAsString() {
        return (String)this.typedValue;
    }

    @Override
    public URL valueAsUrl() {
        return (URL)this.typedValue;
    }

    @Override
    public URL valueAsUrl(PathResolver pathResolver) {
        return (URL)this.typedValue;
    }
}

