<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"
	import="java.util.*"
	import="com.gridnine.xtrip.common.model.asset.AssetsStorage"
	import="com.gridnine.xtrip.common.model.dict.GdsName"
	import="com.gridnine.xtrip.common.search.*"
	import="com.gridnine.xtrip.common.util.TextUtil"
	import="com.gridnine.xtrip.server.gds.model.SearchCityFilterAsset"
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>SearchCityFilterManager - <%=application.getServletContextName()%></title>
</head>
<%
	List<GdsName> gdsNames = new LinkedList<GdsName>();
	for (GdsName gds : GdsName.values()) {
		if (gds.name().startsWith("SIRENA")) {
			gdsNames.add(gds);
		}
	}

	String q_gds = null;
	String q_ak = null;
	String q_city = null;
	SearchResult<SearchCityFilterAsset> result = null;
	if (request.getParameter("query") != null) {
		q_gds = request.getParameter("gds");
		q_ak = request.getParameter("ak");
		q_city = request.getParameter("city");
		SearchQuery query = new SearchQuery();
		query.getCriteria().getCriterions().add(SearchCriterion.eq(SearchCityFilterAsset.Property.gds.name(), q_gds));
		if (!TextUtil.isBlank(q_ak)) {
			query.getCriteria().getCriterions().add(SearchCriterion.eq(SearchCityFilterAsset.Property.airline.name(), q_ak));
		}
		if (!TextUtil.isBlank(q_city)) {
			query.getCriteria().getCriterions().add(SearchCriterion.eq(SearchCityFilterAsset.Property.cityFrom.name(), q_city));
		}
		result = AssetsStorage.get().search(SearchCityFilterAsset.class, query);
	}
%>
<body>
	<h1>SearchCityFilterManager</h1>
	<form method="post">
		<table border="1">
			<tr>
				<td>GSD:
					<select name="gds">
					<% for (GdsName gds : gdsNames) { %>
						<option value="<%= gds.name() %>" <%= gds.name().equals(q_gds) ? "selected" : "" %>><%= gds.toString() %></option>
					<% } %>
					</select>
				</td>
				<td>Airline:
					<input type="text" name="ak" value="<%= TextUtil.isBlank(q_ak) ? "" : q_ak %>" />
				</td>
				<td>City:
					<input type="text" name="city" value="<%=  TextUtil.isBlank(q_city) ? "" : q_city %>" />
				</td>
				<td><input type="submit" name="query" value="query" /></td>
			</tr>
		</table>
	</form>
	<% if (result != null) { %>
	<table>
		<tr>
			<th>uid</th>
			<th>GDS</th>
			<th>Airline</th>
			<th>CityFrom</th>
			<th>Date</th>
			<th>CitiesTo</th>
			<th>Modified</th>
		</tr>
		<% for (SearchCityFilterAsset entry : result.getData()) { %>
			<tr>
				<td><%= entry.getUid() %></td>
				<td><%= entry.getGds() %></td>
				<td><%= entry.getAirline() %> (<%= entry.getAirline().getCode() %>)</td>
				<td><%= entry.getCityFrom() %> (<%= entry.getCityFrom().getCode() %>)</td>
				<td><%= entry.getDate() %></td>
				<td><%= entry.getCitiesTo() %></td>
				<td><%= entry.getModified() %></td>
			</tr>
		<% } %>
	</table>
	<% } %>
</body>
</html>