<%@ page language="java" contentType="text/html; charset=utf-8"
	errorPage="../error.jsp" import="java.io.*" import="java.util.*"
	import="java.text.*" import="com.gridnine.xtrip.common.*"
	import="com.gridnine.xtrip.common.xml.*"
	import="com.gridnine.xtrip.common.search.*"
	import="com.gridnine.xtrip.common.util.*"
	import="com.gridnine.xtrip.common.meta.*"
	import="com.gridnine.xtrip.common.model.*"
	import="com.gridnine.xtrip.common.model.entity.EntityStorage"
	import="com.gridnine.xtrip.common.model.dict.*"
	import="com.gridnine.xtrip.server.storage.*"%><%@ include
	file="../resources/lib.jsp"%><%!static class EntityBrowserContext implements Serializable {
        static EntityBrowserContext get(HttpSession ss) {
            EntityBrowserContext result = null;
            try {
                result = (EntityBrowserContext) ss
                    .getAttribute(EntityBrowserContext.class.getName());
            } catch (Exception e) {
                // ignore;
            }
            if (result != null) {
                return result;
            }
            result = new EntityBrowserContext();
            ss.setAttribute(EntityBrowserContext.class.getName(), result);
            return result;
        }

        private final SearchQuery query;

        private IndexType idx;

        private SearchResult<EntityIndex<BaseEntity>> result;

        private EntityBrowserContext() {
            query = new SearchQuery();
            query.setLimit(100);
            query.setOffset(0);
            query.getCriteria().setFreeTextPattern("");
            query.setResultMode(ResultMode.DATA_AND_COUNT);
        }

        void populate(HttpServletRequest req) throws Exception {
            XUtil.fromString(req.getParameter("query"), query);
            idx = Environment.getPublished(MetaRegistry.class).getIndexes()
                .get(req.getParameter("indexType"));
            if ((idx != null)
                && (req.getParameter("populateProperties") != null)) {
                query.getPreferredProperties().clear();
                for (IndexProperty prop : idx.getProperties().values()) {
                    if (prop.isViewable()) {
                        query.getPreferredProperties().add(prop.getId());
                    }
                }
            } else if (idx != null) {
                for (Iterator<String> it = query.getPreferredProperties()
                    .iterator(); it.hasNext();) {
                    String id = it.next();
                    if (!idx.getProperties().containsKey(id)
                        && !idx.getCollections().containsKey(id)) {
                        it.remove();
                    }
                }
            }
        }

        void doSearch() throws Exception {
            result = EntityStorage.get().search(
                (Class<EntityIndex<BaseEntity>>) XHelper.getClass(idx.getId()),
                query);
        }

        SearchQuery getQuery() {
            return query;
        }

        IndexType getIndexType() {
            return idx;
        }

        SearchResult<EntityIndex<BaseEntity>> getResult() {
            return result;
        }

        void setResult(SearchResult<EntityIndex<BaseEntity>> value) {
            result = value;
        }
    }

    static String render(Object value) {
        if (value == null) {
            return "&nbsp;";
        }
        if (value instanceof EntityReference) {
            EntityReference ref = (EntityReference) value;
            return String.format("<span title='Reference to %s:%s'>%s</span>",
                ref.getType().getName(), ref.getUid(), value);
        }
        if (value instanceof Identity) {
            Identity idt = (Identity) value;
            return String.format("<span title='%s:%s'>%s</span>",
                value.getClass().getName(), idt.getUid(), value);
        }
        if (value instanceof DictionaryReference) {
            DictionaryReference ref = (DictionaryReference) value;
            return String.format("<span title='Reference to %s:%s'>%s</span>",
                ref.getType().getName(), ref.getCode(), value);
        }
        if (value instanceof BaseDictionary) {
            BaseDictionary dict = (BaseDictionary) value;
            return String.format("<span title='%s:%s'>%s</span>",
                value.getClass().getName(), dict.getCode(), value);
        }
        if (value instanceof Enum) {
            Enum en = (Enum) value;
            return String.format("<span title='%s.%s'>%s</span>",
                value.getClass().getName(), en.name(), value);
        }
        if (value instanceof Date) {
            return String.format("<span title='%s'>%tF %<tT</span>",
                value.getClass().getName(), value);
        }
        return String.format("<span title='%s'>%s</span>",
            value.getClass().getName(), value);
    }

    static boolean isAbstract(String entityId) {
        EntityType ett = Environment.getPublished(MetaRegistry.class)
            .getEntities().get(entityId);
        return (ett == null) || ett.isAbstract();
    }%>
<%
    EntityBrowserContext ctx = EntityBrowserContext.get(session);
    if (request.getParameter("search") != null) {
        ctx.populate(request);
        ctx.doSearch();
        response.sendRedirect("entity-browser.jsp");
        return;
    }
    if (request.getParameter("delete") != null) {
        if (request.getParameterValues("uid") != null) {
            Class<BaseEntity> cls = (Class<BaseEntity>) XHelper
                .getClass(request.getParameter("type"));
            for (String uid : request.getParameterValues("uid")) {
                EntityContainer<BaseEntity> ctr = EntityStorage.get()
                    .load(cls, uid);
                if (ctr != null) {
                    EntityStorage.get().delete(ctr);
                }
            }
        }
        ctx.doSearch();
        response.sendRedirect("entity-browser.jsp");
        return;
    }
%>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
<title>Entity Browser - <%=application.getServletContextName()%></title>
<link rel="StyleSheet" type="text/css" href="../resources/base.css">
</head>

<body>

	<form action="entity-browser.jsp" method="post">
		<p>
			Index: <select name="indexType">
				<%
				    List<IndexType> list = new ArrayList<IndexType>(Environment
				        .getPublished(MetaRegistry.class).getIndexes().values());
				    Collections.sort(list, new Comparator<IndexType>() {
				        public int compare(IndexType o1, IndexType o2) {
				            return TextUtil.compare(o1.getDisplayName(),
				                o2.getDisplayName(), true, true);
				        }
				    });
				    for (IndexType idx : list) {
				%>
				<option value="<%=idx.getId()%>"
					<%=idx.equals(ctx.getIndexType()) ? "selected" : ""%>><%=idx.getDisplayName()%></option>
				<%
				    }
				%>
			</select> <input type="checkbox" id="populateProperties"
				name="populateProperties" /> <label for="populateProperties">populate
				all properties</label> <br /> Query:<br />
			<textarea name="query" rows="3" style="width: 100%; height: 200px;"><%=escapeHtml(XSUtil.toString(ctx.getQuery()))%></textarea>
			<br /> <input type="submit" name="search" value="Execute" />
		</p>
	</form>

	<p>
		<%
		    if ((ctx.getIndexType() != null)
		        && !isAbstract(ctx.getIndexType().getEntityId())) {
		%>
		<a href="entity-editor.jsp?type=<%=ctx.getIndexType().getEntityId()%>"
			title="Create new entity of type <%=ctx.getIndexType().getEntityId()%>">new
			entity</a>
		<%
		    }
		%>
	</p>
	<%
	    if (ctx.getResult() != null) {
	%>
	<form action="entity-browser.jsp" method="post">
		<input type="hidden" name="type"
			value="<%=ctx.getIndexType().getEntityId()%>" />
		<table border="1" cellspacing="0" cellpadding="5" width="99%">
			<caption>
				Displayed
				<%=ctx.getResult().getData().size()%>
				of
				<%=ctx.getResult().getTotalCount()%>. Timestamp:
				<%=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")
                    .format(ctx.getResult().getTimestamp())%>
			</caption>
			<tr>
				<th>&nbsp;</th>
				<th>Entity</th>
				<%
				    for (String id : ctx.getQuery().getPreferredProperties()) {
				%>
				<th title="<%=id%>"><%=ctx.getIndexType().getProperties().get(id)
                        .getDisplayName()%></th>
				<%
				    }
				%>
			</tr>
			<%
			    for (EntityIndex<BaseEntity> idx : ctx.getResult().getData()) {
			        if (idx.getSource() == null) {
			            continue;
			        }
			%>
			<tr>
				<td><nobr>
						<input type="checkbox" name="uid"
							value="<%=idx.getSource().getUid()%>" /> <a
							href="entity-editor.jsp?view&type=<%=idx.getSource().getType().getName()%>&uid=<%=idx.getSource().getUid()%>">VIEW</a>
						<a
							href="entity-editor.jsp?type=<%=idx.getSource().getType().getName()%>&uid=<%=idx.getSource().getUid()%>">EDIT</a>
						<a
							href="sys-log.jsp?refType=<%=idx.getSource().getType().getName()%>&refUid=<%=idx.getSource().getUid()%>">LOG</a>
					</nobr></td>
				<td><%=render(idx.getSource())%></td>
				<%
				    for (String id : ctx.getQuery().getPreferredProperties()) {
				%>
				<td><%=render(idx.getValue(id))%></td>
				<%
				    }
				%>
			</tr>
			<%
			    }
			%>
		</table>
		<p>
			<input type="submit" name="delete" value="Delete"
				onclick="return confirm('Sure to delete selected entities?')" />
		</p>
	</form>
	<%
	    }
	%>

</body>
</html>