<%@page contentType="text/html; charset=UTF-8"%>

<!DOCTYPE html>
<html lang="ru" >
<head>
    <meta charset='utf-8'/>
    <title>Calendar Scheduled Tasks</title>
    <style>
        html, body {
            margin: 0;
            padding: 0;
            font-family: Arial, Helvetica Neue, Helvetica, sans-serif;
            font-size: 14px;
        }

        #calendar {
            max-width: 1900px;
            margin: 4px auto;
        }

        .task_run_5 {
            background: #ff0000;
        }

        .task_run_3 {
            background: #ff6600;
        }
    </style>

    <script type="text/javascript" src="../resources/index.global.min.js"></script>

    <script>

        document.addEventListener('DOMContentLoaded', function () {
            var calendarEl = document.getElementById('calendar');

            var calendar = new FullCalendar.Calendar(calendarEl, {
                timeZone: 'UTC',
                headerToolbar: {
                    left: 'today prev,next',
                    center: 'title',
                    right: 'resourceTimelineDay, resourceTimelineThreeDay'
                },
                initialView: 'resourceTimelineDay',
                scrollTime: '01:00',
                aspectRatio: 2.5,
                timeFormat: 'HH:mm',

                slotMinTime: '00:00:00',

                defaultTimedEventDuration: '00:01:00',
                displayEventTime: true,
                displayEventEnd: false,
                eventTimeFormat: {
                    hour: '2-digit',
                    hour12: false,
                    minute: '2-digit',
                    omitZeroMinute: false,
                    meridiem: false
                },

                resourceAreaWidth: '20%',
                views: {
                    resourceTimelineDay: {
                        type: 'resourceTimeline',
                        duration: {days: 1},
                        buttonText: '1 days',
                        slotDuration: '00:02:00',
                        slotMinWidth: 100,
                        slotLabelInterval: '00:10:00',
                        slotLabelFormat: {
                            hour: '2-digit',
                            hour12: false,
                            minute: '2-digit',
                            omitZeroMinute: false,
                            meridiem: false
                        },
                    },
                    resourceTimelineThreeDay: {
                        type: 'resourceTimeline',
                        duration: {days: 3},
                        buttonText: '3 days',
                        slotDuration: '00:15:00',
                        slotMinWidth: 700,
                        slotLabelInterval: {hour: 4},
                        slotLabelFormat: [{
                            year: '2-digit',
                            month: '2-digit',
                            day: '2-digit',
                        },
                            {
                            hour: '2-digit',
                            hour12: false,
                            minute: '2-digit',
                            omitZeroMinute: false,
                            meridiem: false
                        }]
                    }
                },
                resourceAreaHeaderContent: 'Task',
                resources: 'scheduled-tasks-calendar-resources.jsp',
                events: 'scheduled-tasks-calendar-events.jsp'
            });

            calendar.render();
        });

    </script>

</head>

<body>
<table>
    <caption>Simultaneous launch of tasks</caption>
    <tbody>
    <td class="task_run_3">&nbsp;&nbsp;&nbsp;</td>
    <td> from 3 to 5 </td>
    <td class="task_run_5">&nbsp;&nbsp;&nbsp;</td>
    <td> from 5 ... </td>
    </tbody>
    <br>
</table>
<div id='calendar'></div>
</body>

</html>
