package com.gridnine.xtrip.server.ibecorp.scripts.updateTimeZoneIds

import com.gridnine.xtrip.common.model.dict.DictionaryCache
import com.gridnine.xtrip.common.model.dict.GeoLocation
import com.gridnine.xtrip.common.model.dict.LocationType
import com.gridnine.xtrip.server.model.tasks.standard.ExecuteGroovyScriptTask
import com.gridnine.xtrip.server.storage.DictionaryStorage
import org.apache.commons.lang.StringUtils

import java.nio.charset.StandardCharsets

def citiesToUpdateTimeZoneID = DictionaryCache.get().getAll(GeoLocation.class).values()

ExecuteGroovyScriptTask.InputFile file = inputFile;
if (file == null) {
    message("no file");
    return;
}

String res = new String(file.body, StandardCharsets.UTF_8);
List<String> list = Arrays.asList(res.split(";"));
Map<String, String> iataCode2TimeZoneId = new HashMap<>();
list.stream()
        .filter({ s -> !StringUtils.isEmpty(s) })
        .forEach({ str -> iataCode2TimeZoneId.put(str.split(":")[0], str.split(":")[1]) });

def ds = DictionaryStorage.get()
citiesToUpdateTimeZoneID
        .findAll {geo -> null != geo.codeVariants.get("IATA") }
        .findAll {geo -> geo.type == LocationType.CITY }
        .findAll { geo -> org.apache.commons.lang.StringUtils.isEmpty(geo.timeZoneId) }
        .findAll { geo -> iataCode2TimeZoneId.containsKey(geo.codeVariants.get("IATA")) }
        .each { geo ->
            geo.setTimeZoneId(iataCode2TimeZoneId.get(geo.codeVariants.get("IATA")))
            geo.setDataSource('UpdateCitiesWithTimeZoneIds')
            ds.save(geo)
        }
