package com.gridnine.xtrip.server.ibecorp.tasks.groovy

import com.gridnine.xtrip.common.model.EntityContainer
import com.gridnine.xtrip.common.model.dict.ContractType
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper
import com.gridnine.xtrip.common.model.profile.Contract
import com.gridnine.xtrip.common.model.profile.Contract2ModelContract
import com.gridnine.xtrip.common.model.profile.ContractIndex
import com.gridnine.xtrip.common.model.profile.ModelContract
import com.gridnine.xtrip.common.model.rules.standard.ContractActions
import com.gridnine.xtrip.common.model.rules.standard.SupplierActions
import com.gridnine.xtrip.common.search.SearchCriterion
import com.gridnine.xtrip.common.search.SearchQuery

StringBuilder builder = new StringBuilder()
Set<String> result = new HashSet<>()

SearchQuery query = new SearchQuery()
query.getCriteria().getCriterions()
        .add(SearchCriterion.eq(ContractIndex.Property.contractType.name(), ContractType.VENDOR))

List<ContractIndex> contractIndexList =
        EntityStorage.get().search(ContractIndex.class, query).data

for (ContractIndex contractIndex : contractIndexList) {
    EntityContainer<Contract> contractCtr =
            EntityStorage.get().resolve(contractIndex.source)
    if (EntityStorageHelper.nonEmpty(contractCtr)) {
        Contract contract = contractCtr.entity
        for (Contract2ModelContract contract2ModelContract : contract.modelContracts) {
            EntityContainer<ModelContract> modelContractCtr =
                    EntityStorage.get().resolve(contract2ModelContract.modelContract)
            if (EntityStorageHelper.nonEmpty(modelContractCtr)) {
                ModelContract modelContract = modelContractCtr.entity
                if (modelContract.ruleSet != null) {
                    modelContract.ruleSet.rules.stream()
                            .filter({ it.target.id == "HOTELS_COMMISSION" })
                            .filter({
                                it.results.stream()
                                        .anyMatch({
                                            (it.action == ContractActions.CONTRACT
                                                    || it.action == SupplierActions.SUPPLIER
                                                    || it.action == SupplierActions.PRODUCT_BLANK_OWNER)
                                        })
                            })
                            .forEach({
                                result.addAll(it.restrictions.collect { it.property?.id })
                            })
                }
            }
        }
    }
}

result.forEach({ builder.append(it).append("\n") })

answer.booleanData = builder.length() > 0
answer.textData = builder.toString()
