package com.gridnine.xtrip.server.ibecorp.tasks.groovy

import com.gridnine.xtrip.common.gds.rules.Targets
import com.gridnine.xtrip.common.model.EntityContainer
import com.gridnine.xtrip.common.model.EntityReference
import com.gridnine.xtrip.common.model.dict.ContractType
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper
import com.gridnine.xtrip.common.model.profile.BaseRulesContainer
import com.gridnine.xtrip.common.model.profile.ContractIndex
import com.gridnine.xtrip.common.model.profile.ModelContractIndex
import com.gridnine.xtrip.common.rules.RuleSettings
import com.gridnine.xtrip.common.search.SearchCriterion
import com.gridnine.xtrip.common.search.SearchQuery

searchOldContracts()
searchModelContracts()


private void searchOldContracts(){
    SearchQuery sq = new SearchQuery()
    sq.getCriteria().getCriterions().add(SearchCriterion.eq(ContractIndex.Property.newModel.name(), false))
    sq.getCriteria().getCriterions().add(SearchCriterion.eq(ContractIndex.Property.contractType.name(), ContractType.VENDOR))

    List<ContractIndex> contracts = EntityStorage.get().search(ContractIndex.class, sq).getData()

    message("Найдено ${contracts.size()} старых договоров с поставщиком");

    List<String> names = new ArrayList<>();
    for (ContractIndex idx : contracts) {
        checkRules(idx.getSource(), names)
    }
    message("Итого найдено ${names.size()} контрактов с правилом: \n ${names}");
}

private void searchModelContracts(){
    SearchQuery sq = new SearchQuery()
    EntityStorage es = EntityStorage.get()
    List<ModelContractIndex> modelContracts = es.search(ModelContractIndex.class, sq).getData()

    message("Найдено ${modelContracts.size()} групп правил");

    List<String> names = new ArrayList<>();
    for (ModelContractIndex idx : modelContracts) {
        checkRules(idx.getSource(), names)
    }
    message("Итого найдено ${names.size()} групп правил с правилом: \n ${names}");
}

private void checkRules(EntityReference<? extends BaseRulesContainer> ref, ArrayList<String> names) {
    EntityContainer<? extends BaseRulesContainer> ctr = EntityStorage.get().resolve(ref)

    if (EntityStorageHelper.nonEmpty(ctr)) {
        BaseRulesContainer entity = ctr.getEntity()
        if (entity.getRuleSet() == null) {
            return;
        }
        List<RuleSettings> rules = entity.getRuleSet().rules.findAll { it.target == Targets.REFUND_PARAMETERS }
        if (!rules.empty) {
            names.add(entity.getName())
        }
    }
}

