//CREATING STYLES
createStyle(name: 'title',fontBold: true, h_span: 12, h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight:20)
createStyle(name: 'header',fontBold: false,  h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight:10, leftBorder:'MEDIUM', rightBorder:'MEDIUM', topBorder:'MEDIUM', bottomBorder:'MEDIUM', wrapText: true)
createStyle(name: 'data',fontBold: false,  h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight:10, leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN')
createStyle(name: 'textData',parent: 'data')
createStyle(name: 'numberData',parent: 'data',h_alignment: 'RIGHT')
createStyle(name: 'dateData',parent: 'data',h_alignment: 'RIGHT',format: 'm/d/yy')
createStyle(name: 'subtotalTitle', parent: 'header', h_span: 6, h_alignment: 'RIGHT', fontBold: true)
createStyle(name: 'subtotalNumber',parent: 'subtotalTitle',  h_span: 1)
createStyle(name: 'totalTitle', parent: 'subtotalTitle', h_span: 3)
createStyle(name: 'totalNumber',parent: 'totalTitle')
//ADDITIONAL FUNCTIONS
def sum = {BigDecimal... values ->
    BigDecimal result = BigDecimal.ZERO
    values.each {
        if(it != null){
            result = result.add(it)
        }
    }
    return result
}
def multi = {BigDecimal... values ->
    BigDecimal result = BigDecimal.ONE
    values.each {
        if(it == null){
            result == BigDecimal.ZERO
            return
        }
        result = result.multiply(it)
    }
    return result
}
def priceFactor = {def it->
    return ('REFUND'.equals(it.status?.name()) ||'EXCHANGE'.equals(it.status?.name()))? BigDecimal.ONE.negate(): BigDecimal.ONE
}
def fare =  {def it->
    return multi(priceFactor(it), it.equivalentFare)
}
def taxes =  {def it->
    return multi(priceFactor(it), it.taxesSum)
}
def penalty =  {def it->
    return it.penalty == null? BigDecimal.ZERO: it.penalty
}
def total =  {def it->
    return taxes(it).add(fare(it)).add(penalty(it))
}
def bspCommissionAmount =  {def it->
    return multi(priceFactor(it), it.bspCommissionEquivalentAmount)
}


//REPORT
page{it.transportationType?.name()}{
    //TITLE
    rowHeight(30)
    setStyle('title')
    text("Сводный реестр по авиакомпаниям (${'INTERNATIONAL'.equals(it)? 'МВЛ': 'ВВЛ'}) за период ${parameters.REPORT_PERIOD}")
    //HEADER
    setStyle('normal')
    nextRow()
    rowHeight(15)
    nextRow()
    rowHeight(40)
    setStyle('header')
    text('Р/К валид.  п-ка')
    nextColumn()
    columnWidth(20)
    text('Валид. перевозчик')
    nextColumn()
    columnWidth(30)
    text('Маршрут')
    nextColumn()
    columnWidth(12)
    text('Номер билета')
    nextColumn()
    columnWidth(7)
    text('Статус')
    nextColumn()
    columnWidth(10)
    text('Дата выписки')
    nextColumn()
    columnWidth(7)
    text('Экв. тариф')
    nextColumn()
    columnWidth(7)
    text('Сумма такс')
    nextColumn()
    columnWidth(7)
    text('Штраф')
    nextColumn()
    columnWidth(7)
    text('Сумма общая')
    nextColumn()
    columnWidth(7)
    text('% ком. BSP')
    nextColumn()
    columnWidth(7)
    text('Сумма ком. BSP')
    def summCells = []
    //DATA
    groups{it.validatingCarrierNumber}{
        nextRow()
        String fareRow = cellIndex(0,6)
        String taxesRow = cellIndex(0,7)
        String penaltyRow = cellIndex(0,8)
        String totalRow = cellIndex(0,9)
        String bspRow = cellIndex(0,11)
        tickets{
            rowHeight(10)
            text(it.validatingCarrierNumber,'textData')
            nextColumn()
            text(it.validatingCarrier?.toString(),'textData')
            nextColumn()
            text(it.routeLine,'textData')
            nextColumn()
            text(it.ticketNumber,'textData')
            nextColumn()
            text(it.status?.toString(),'textData')
            nextColumn()
            date(it.issueDate,'dateData')
            nextColumn()
            number(fare(it),'numberData')
            nextColumn()
            number(taxes(it),'numberData')
            nextColumn()
            number(penalty(it),'numberData')
            nextColumn()
            number(total(it),'numberData')
            nextColumn()
            number(it.bspCommissionPercent,'numberData')
            nextColumn()
            number(bspCommissionAmount(it),'numberData')
            nextRow()
        }
        //SUBTOTAL
        text('Итого','subtotalTitle')
        nextColumn()
        formula("SUM(${fareRow}:${cellIndex(-1,0)})",'subtotalNumber')
        nextColumn()
        formula("SUM(${taxesRow}:${cellIndex(-1,0)})",'subtotalNumber')
        nextColumn()
        formula("SUM(${penaltyRow}:${cellIndex(-1,0)})",'subtotalNumber')
        nextColumn()
        formula("SUM(${totalRow}:${cellIndex(-1,0)})",'subtotalNumber')
        summCells << cellIndex(0,0)
        nextColumn()
        number(null,'subtotalNumber')
        nextColumn()
        formula("SUM(${bspRow}:${cellIndex(-1,0)})",'subtotalNumber')
    }

    //TOTAL
    2.times{nextRow()}
    6.times{nextColumn()}
    text('Итого к перечислению', 'totalNumber')
    nextColumn()
    rowHeight(15)
    if(summCells.isEmpty()){
        number(BigDecimal.ZERO, 'totalNumber')
    } else{
        int idx = 0;
        String formulaStr = 'SUM('
        summCells.each {
            if(idx >0){
                formulaStr = formulaStr + ','
            }
            idx++
            formulaStr = formulaStr + it
        }
        formula( formulaStr+')', 'totalNumber')
    }
}

