// Imports
import com.gridnine.xtrip.common.model.dict.CurrencyInfo
import com.gridnine.xtrip.common.model.helpers.DictHelper
import java.text.SimpleDateFormat
import com.gridnine.xtrip.common.l10n.model.LocaleHelper
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.helpers.PersonalLocalizableNameFormatter
import com.gridnine.xtrip.common.model.helpers.ProfileHelper
import com.gridnine.xtrip.common.model.system.PaymentType
import com.gridnine.xtrip.common.reports.AgentReportHelper
import com.gridnine.xtrip.common.util.MiscUtil
import com.gridnine.xtrip.common.util.TextUtil

// Styles
createStyle(name: 'title', h_alignment: 'CENTER', v_alignment: 'CENTER')
createStyle(name: 'titleH1', fontHeight: 14, parent: 'title')
createStyle(name: 'titleH2', fontHeight: 9, parent: 'title')
createStyle(name: 'titleH3', fontHeight: 7, parent: 'title')
createStyle(name: 'header', h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight: 7)
createStyle(name: 'columnHeader', wrapText: true, parent: 'header')
createStyle(name: 'rowHeader', wrapText: true, parent: 'header')
createStyle(name: 'data', h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight: 7)
createStyle(name: 'dataText', parent: 'data')
createStyle(name: 'dataDate', format: 'm/d/yy', parent: 'data')
createStyle(name: 'dataNumber', h_alignment: 'RIGHT', format: '#,##0.00', parent: 'data')
createStyle(name: 'ahl', h_alignment: 'LEFT')
createStyle(name: 'ahc', h_alignment: 'CENTER')
createStyle(name: 'ahr', h_alignment: 'RIGHT')
createStyle(name: 'avt', v_alignment: 'TOP')
createStyle(name: 'avc', v_alignment: 'CENTER')
createStyle(name: 'avb', v_alignment: 'BOTTOM')
createStyle(name: 'aac', h_alignment: 'CENTER', v_alignment: 'CENTER')
createStyle(name: 'bold', fontBold: true)
createStyle(name: 'italic', fontItalic: true)
createStyle(name: 'bt', topBorder: 'THIN')
createStyle(name: 'bl', leftBorder: 'THIN')
createStyle(name: 'bb', bottomBorder: 'THIN')
createStyle(name: 'br', rightBorder: 'THIN')
createStyle(name: 'ba', topBorder: 'THIN', leftBorder: 'THIN', bottomBorder: 'THIN', rightBorder: 'THIN')
createStyle(name: 'grey25', foreground: 'GREY_25_PERCENT')
createStyle(name: 'locked', locked: true)

// Properties
def periodBeginParameter = parameters['key-report-params']?.periodBegin
def periodEndParameter = parameters['key-report-params']?.periodEnd
def subagencyParameter = parameters['key-report-params']?.subagency
def salesPointParameter = parameters['key-report-params']?.salesPoint
def cashRegisterParameter = parameters['key-report-params']?.cashRegister
def cashRegisterWorkplaceParameter = parameters['key-report-params']?.cashRegisterWorkplace
def agentParameter = parameters['key-report-params']?.agent

// Closures
def agency = {
    
    def subagency = EntityStorage.get().resolve(subagencyParameter)?.entity
    def salesPoint = EntityStorage.get().resolve(salesPointParameter)?.entity
    def agency = subagency ? subagency : EntityStorage.get().resolve(salesPoint?.agency)?.entity
    return agency ? ProfileHelper.getFullName(agency, LocaleHelper.getLocale('ru', 'RU'), false) : 'Не указано'
}

def salesPoint = {
    
    def salesPoint = EntityStorage.get().resolve(salesPointParameter)?.entity
    return salesPoint ? ProfileHelper.getFullName(salesPoint) : 'Не указано'
}

def agent = {
    
    def agent = EntityStorage.get().resolve(agentParameter)?.entity
    return agent ? new PersonalLocalizableNameFormatter('L f m').format(agent, LocaleHelper.getLocale('ru', 'RU'), false) : 'Не указано'
}

def period = {
    
    def format = new SimpleDateFormat('dd.MM.yy HH:mm')
    return String.format('с %s по %s', periodBeginParameter != null ? format.format(periodBeginParameter) : '?', periodEndParameter != null ? format.format(periodEndParameter) : '?')
}

page{'КРС'}{
    
    // Set landcape mode
    landscape(true)

    // Set narrow margins
    margin(0.25, 0.25, 0.75, 0.75)

    CurrencyInfo currencyInfo = DictHelper.getCurrencyInfoByAnyCode(DictHelper.getLocalCurrencyCode())
    def currency = currencyInfo?.toString(LocaleHelper.RU_LOCALE)

    // Report header
    text(agency(), 'titleH1|ahl|bold', 6, 1)
    
    columnWidth(4)
    nextColumn()
    columnWidth(5)
    nextColumn()
    columnWidth(12)
    nextColumn()
    columnWidth(17)
    nextColumn()
    columnWidth(17)
    nextColumn()
    columnWidth(17)

    nextRow()
    text('Реестр КРС к отчету', 'titleH2|ahl|bold', 6, 1)
    2.times{nextRow()}
    2.times{nextColumn()}
    text('Точка продажи', 'titleH2|ahr|bold')
    nextColumn()
    text(salesPoint(), 'titleH2|ahl|bold')
    nextRow()
    2.times{nextColumn()}
    text('Агент', 'titleH2|ahr|bold')
    nextColumn()
    text(agent(), 'titleH2|ahl|bold')
    nextRow()
    2.times{nextColumn()}
    text('Период', 'titleH2|ahr|bold')
    nextColumn()
    text(period(), 'titleH2|ahl|bold')
    2.times{nextRow()}
    
    // Table header (first row)
    text('№', 'columnHeader|ba')
    nextColumn()
    text('№ КРС', 'columnHeader|ba', 2, 1)
    2.times{nextColumn()}
    text('№ билета', 'columnHeader|ba')
    nextColumn()
    text("Сумма,\n${currency}", 'columnHeader|ba')
    nextColumn()
    text('Примечания', 'columnHeader|ba')
    nextRow()
    
    // Table
    def ticketsCount = 0
    
    tickets{

        text(String.valueOf(ticketsCount + 1), 'dataText|ba')
        nextColumn()
        text(it.ticketSeries, 'dataText|ba')
        nextColumn()
        text(it.systemNumber, 'dataText|ba')
        nextColumn()
        text(it.relatedSystemNumber, 'dataText|ba')
        nextColumn()
        number(it.relatedPaymentAmount, 'dataNumber|ba')
        nextColumn()
        text(it.relatedPaymentType?.toString(), 'dataText|ba')
        nextRow()
        
        ticketsCount++
    }
    
    text('Итого:', 'dataText|ahr|bold|italic|ba', 4, 1)
    4.times{nextColumn()}
    
    formula(ticketsCount > 0 ? "SUM(${cellIndex(-ticketsCount, 0)}:${cellIndex(-1, 0)})" : null, 'dataNumber|bold|italic|ba')
    nextColumn()
    
    text(null, 'dataText|bold|italic|ba')
    3.times{nextRow()}
    
    // Report footer
    2.times{nextColumn()}
    text('Подпись', 'titleH2|ahr')
    nextColumn()
    text(null, 'titleH2|bb', 2, 1)
    2.times{nextColumn()}
    text("${agent()}", 'titleH2|ahl')
}
