import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportTicket

//CREATING STYLES
createStyle(name: 'baseStyle', fontBold: true,  h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight:12)
createStyle(name: 'bigHeader', parent: 'baseStyle', fontHeight:18)
createStyle(name: 'midHeader', parent: 'baseStyle',h_alignment: 'LEFT')
createStyle(name: 'smallHeader', parent:'baseStyle', fontHeight:8, h_alignment: 'RIGHT')
createStyle(name: 'smallHeaderCenter', parent: 'smallHeader', h_alignment: 'CENTER')
createStyle(name: 'tableHeader', parent: 'baseStyle', fontHeight:11, leftBorder:'MEDIUM', rightBorder:'MEDIUM', topBorder:'MEDIUM', bottomBorder:'MEDIUM')
createStyle(name: 'tableContent', parent: 'baseStyle', fontHeight:11, fontBold: false, leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN')
createStyle(name: 'textData', parent: 'tableContent')
createStyle(name: 'textDataBold', parent: 'tableContent', fontBold: true)
createStyle(name: 'dateData', format: 'm/d/yy', parent: 'tableContent')
createStyle(name: 'dateDataBold', format: 'm/d/yy', parent: 'tableContent', fontBold: true)
createStyle(name: 'numberData', format: '#,##0.00', parent: 'tableContent')
createStyle(name: 'emptyNumberData', parent: 'tableContent')
createStyle(name: 'numberDataBold', format: '#,##0.00', parent: 'tableContent', fontBold: true)

//ADDITIONAL FUNCTIONS
class Formula{
    String formula
    Formula(){}
    Formula(String formula) {
        this.formula = formula
    }

    static Formula getSumFormulaByRow (String start, String end) {
        return new Formula ('SUM(' + start + ':' + end + ')')
    }
    static Formula getSumFormulaByCell (String... index) {
        def formula = ''
        for (int i=0; i<index.size(); i++) {
            if(i == 0) {
                formula += index[i]
            } else {
                formula += ',' + index[i]
            }
        }
        return new Formula('SUM(' + formula + ')')
    }
}

def cellFill = { value ->
    if (value != null) {
        if (value instanceof Number) {
            number(value,'numberData')
        } else if (value instanceof Date) {
            date(value,'dateData')
        } else if (value instanceof Formula){
            formula(value.formula,'numberData')
        } else {
            text(value, 'textData')
        }
    } else {
        text('', 'textData')
    }
}

def cellFillBold = { value ->
    if (value != null) {
        if (value instanceof Number) {
            number(value,'numberDataBold')
        } else if (value instanceof Date) {
            date(value,'dateDataBold')
        } else {
            text(value, 'textDataBold')
        }
    } else {
        text('', 'textDataBold')
    }
}

def nextColumnEmptyContent = {
    cellFill('')
    nextColumn()
}

def reportHeader = {
    rowHeight(20)
    nextColumn()
    text('Реестр по обмену перевозочных документов', 'bigHeader', 9, 1)
    2.times {nextRow()}
    text('Владелец БСО', 'baseStyle', 4, 1)
    5.times {nextColumn()}
    text('Период расчетов: ' + parameters.REPORT_PERIOD, 'midHeader', 9, 1)
    nextRow()
    text('Код взаиморасчетов', 'baseStyle', 4, 1)
    nextRow()
    text('Регион перевозок', 'baseStyle', 4, 1)
    nextRow()
}

def createSumFormulaForColumn = {int rowShift->
    return Formula.getSumFormulaByRow(cellIndex(rowShift, 0), cellIndex(-1, 0))
}

def fillReportEndRow = {String jobPosition->
    3.times {nextRow()}
    text(jobPosition, 'baseStyle', 4, 1)
    5.times {nextColumn()}
    text('ФИО', 'baseStyle', 2, 1)
}

def reportEnd = {
    text('Итого', 'baseStyle', 4, 1)
    6.times {nextColumn()}
    int rowShift = -(allTickets.size())
    cellFill(createSumFormulaForColumn(rowShift))
    2.times {nextColumn()}
    8.times {
        createSumFormulaForColumn(rowShift)
        nextColumn()
    }
    fillReportEndRow('Испольнительный директор')
    fillReportEndRow('Главный бухгалтер')
    fillReportEndRow('Испольнитель')
}

def tableHeader = {
    rowHeight(15)
    text('№ п/п', 'tableHeader', 1, 2)
    columnWidth(10)
    nextColumn()
    text('Вид БСО', 'tableHeader', 1, 2)
    columnWidth(15)
    nextColumn()
    text('Серийный № документа', 'tableHeader', 1, 2)
    columnWidth(28)
    nextColumn()
    text('Дата продажи', 'tableHeader', 1, 2)
    columnWidth(20)
    nextColumn()
    columnWidth(15)
    text('Тариф', 'tableHeader', 2, 1)
    2.times {
        nextColumn()
        columnWidth(15)
    }
    text('Комиссия', 'tableHeader', 1, 2)
    columnWidth(15)
    nextColumn()
    columnWidth(15)
    text('Сумма доплаты', 'tableHeader', 9, 1)
    9.times {
        nextColumn()
    }
    text('EMD', 'tableHeader', 1, 2)
    columnWidth(20)
    nextRow()
    4.times {nextColumn()}
    text('%', 'tableHeader')
    nextColumn()
    text('сумма', 'tableHeader')
    2.times {nextColumn()}
    text('%', 'tableHeader')
    columnWidth(15)
    nextColumn()
    text('Тариф', 'tableHeader')
    columnWidth(15)
    nextColumn()
    text('ТН', 'tableHeader')
    columnWidth(15)
    nextColumn()
    text('АГС', 'tableHeader')
    columnWidth(15)
    nextColumn()
    text('Такса SA', 'tableHeader')
    columnWidth(15)
    nextColumn()
    text('Сборы Агента', 'tableHeader')
    columnWidth(20)
    nextColumn()
    text('Комиссия', 'tableHeader')
    columnWidth(15)
    nextColumn()
    text('Штраф', 'tableHeader')
    columnWidth(15)
    nextColumn()
    text('Итого', 'tableHeader')
    columnWidth(15)
    nextRow()
}

def tableBody = {
    int row = 0
    allTickets.each {AirTicketsTemplateReportTicket ticket ->
        2.times {nextColumnEmptyContent()}
        cellFill(ticket.ticketNumber)
        nextColumn()
        cellFill(ticket.issueDate)
        nextColumn()
        3.times {nextColumnEmptyContent()}
        cellFill(ticket.vendorCommissionRate)
        nextColumn()
        cellFill(ticket.equivalentFare)
        nextColumn()
        4.times {nextColumnEmptyContent()}
        cellFill(ticket.vendorCommissionValue)
        nextColumn()
        cellFill(ticket.penalty)
        nextColumn()
        2.times {nextColumnEmptyContent()}
        nextRow()
        row++
    }
}

def reportBody = {
    tableHeader()
    tableBody()
}

page{'Exchange registry'} {
    warn 'report version = ' + '0.1.0'

    reportHeader()
    reportBody()
    reportEnd()
}