// Imports
import java.text.SimpleDateFormat

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.util.MiscUtil;

// Styles
createStyle(name: 'title', h_alignment: 'CENTER', v_alignment: 'CENTER')
createStyle(name: 'titleH1', fontHeight: 14, parent: 'title')
createStyle(name: 'titleH2', fontHeight: 9, parent: 'title')
createStyle(name: 'header', h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight: 7)
createStyle(name: 'columnHeader', wrapText: true, parent: 'header')
createStyle(name: 'rowHeader', wrapText: true, parent: 'header')
createStyle(name: 'data', h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight: 7)
createStyle(name: 'dataText', parent: 'data')
createStyle(name: 'dataDate', format: 'm/d/yy', parent: 'data')
createStyle(name: 'dataNumber', h_alignment: 'RIGHT', format: '#,##0.00', parent: 'data')
createStyle(name: 'ahl', h_alignment: 'LEFT')
createStyle(name: 'ahc', h_alignment: 'CENTER')
createStyle(name: 'ahr', h_alignment: 'RIGHT')
createStyle(name: 'avt', v_alignment: 'TOP')
createStyle(name: 'avc', v_alignment: 'CENTER')
createStyle(name: 'avb', v_alignment: 'BOTTOM')
createStyle(name: 'aac', h_alignment: 'CENTER', v_alignment: 'CENTER')
createStyle(name: 'bold', fontBold: true)
createStyle(name: 'italic', fontItalic: true)
createStyle(name: 'bt', topBorder: 'THIN')
createStyle(name: 'bl', leftBorder: 'THIN')
createStyle(name: 'bb', bottomBorder: 'THIN')
createStyle(name: 'br', rightBorder: 'THIN')
createStyle(name: 'ba', topBorder: 'THIN', leftBorder: 'THIN', bottomBorder: 'THIN', rightBorder: 'THIN')
createStyle(name: 'grey25', foreground: 'GREY_25_PERCENT')

// Properties
def periodBeginParameter = parameters['key-report-params']?.periodBegin;
def periodEndParameter = parameters['key-report-params']?.periodEnd;
def agencyParameter = parameters['key-report-params']?.agency;

// Closures
def agency = {

    def agency = EntityStorage.get().resolve(agencyParameter)?.entity;
    return agency ? ProfileHelper.getFullName(agency, LocaleHelper.getLocale('ru', 'RU'), false) : 'Не указано';
}

def code = {

    def profile = EntityStorage.get().resolve(agencyParameter)?.entity;

    if(profile) {

        def code = ProfileHelper.findMetadataStringByCode(profile.metadata, MetadataKey.KEY_SU_2013_AGENCY_CODE.name())
        return code ? code : ''
    }

    return '';
}

def agencyCity = {

    def profile = EntityStorage.get().resolve(agencyParameter)?.entity;
    def city = Environment.getPublished(DictionaryCache.class).resolveReference(ProfileHelper.filterAddresses(profile?.addresses, AddressType.LEGAL)?.city)
    return city ? city.toString() : ''
}

def year = {

    def calendar = Calendar.getInstance()

    if(periodBeginParameter) {
        calendar.setTime(periodBeginParameter)
    }

    return calendar.get(Calendar.YEAR);
}

def month = {

    def calendar = Calendar.getInstance()

    if(periodBeginParameter) {
        calendar.setTime(periodBeginParameter)
    }

    return calendar.get(Calendar.MONTH) + 1;
}

def monthName = {

    def number = month()

    if(number == 1) {
        return 'январь'
    } else if(number == 2) {
        return 'февраль'
    } else if(number == 3) {
        return 'март'
    } else if(number == 4) {
        return 'апрель'
    } else if(number == 5) {
        return 'май'
    } else if(number == 6) {
        return 'июнь'
    } else if(number == 7) {
        return 'июль'
    } else if(number == 8) {
        return 'август'
    } else if(number == 9) {
        return 'сентябрь'
    } else if(number == 10) {
        return 'октябрь'
    } else if(number == 11) {
        return 'ноябрь'
    } else if(number == 12) {
        return 'декабрь'
    }

    return ''
}

page{'DataByMonth'}{

    // Set landcape mode
    landscape(true)

    // Set defalt row height
    rowHeight(13.2)

    text('Оперативные данные по выручке за ' + monthName().toString() + ' ' + year().toString(), 'titleH2|aac', 12, 1)
    2.times{nextRow()}

    // Report header
    rowHeight(35, false)
    columnWidth(28)
    text('Агент/филиал/представительство', 'columnHeader|ba')
    nextColumn()
    columnWidth(6)
    text('Код агента', 'columnHeader|ba')
    nextColumn()
    columnWidth(16)
    text('Город', 'columnHeader|ba')
    nextColumn()
    columnWidth(6)
    text('Год', 'columnHeader|ba')
    nextColumn()
    columnWidth(6)
    text('Месяц', 'columnHeader|ba')
    nextColumn()
    columnWidth(34)
    text('Канал продаж', 'columnHeader|ba')
    nextColumn()
    columnWidth(12)
    text('Тип перевозки', 'columnHeader|ba')
    nextColumn()
    columnWidth(8)
    text('МВЛ/ВВЛ', 'columnHeader|ba')
    nextColumn()
    columnWidth(12)
    text('Тариф всего (руб.)', 'columnHeader|ba')
    nextColumn()
    columnWidth(12)
    text('Топливный сбор (руб.)', 'columnHeader|ba')
    nextColumn()
    columnWidth(12)
    text('Остальные таксы и сборы (руб.)', 'columnHeader|ba')
    nextColumn()
    columnWidth(12)
    text('Агентская комиссия (руб.)', 'columnHeader|ba')
    nextColumn()
    nextRow()

    def totals = [:]

    def blankOwnerKeys = ['su', 'bsp', 'tch']
    def transportationTypeKeys = ['mvl', 'vvl']
    def tariffTypeKeys = [
        'regular',
        'block',
        'charter'
    ]

    for(blankOwnerKey in blankOwnerKeys) {

        totals[blankOwnerKey] = [:]

        for(transportationTypeKey in transportationTypeKeys) {

            totals[blankOwnerKey][transportationTypeKey] = [:]

            for(tariffTypeKey in tariffTypeKeys) {

                totals[blankOwnerKey][transportationTypeKey][tariffTypeKey] = [:]

                totals[blankOwnerKey][transportationTypeKey][tariffTypeKey]['tariffs'] = BigDecimal.ZERO
                totals[blankOwnerKey][transportationTypeKey][tariffTypeKey]['taxesFuel'] = BigDecimal.ZERO
                totals[blankOwnerKey][transportationTypeKey][tariffTypeKey]['taxesOthers'] = BigDecimal.ZERO
                totals[blankOwnerKey][transportationTypeKey][tariffTypeKey]['commissions'] = BigDecimal.ZERO
            }
        }
    }

    // Initialization
    tickets{

        def blankOwnerCode = ProfileHelper.findOrganizationCode(it.blankOwner)
        def supplierCode = ProfileHelper.findOrganizationCode(it.supplier)

        if(blankOwnerCode && supplierCode && blankOwnerCode.equals(supplierCode)) {

            def blankOwnerKey = null;

            if(blankOwnerCode.equals('SU')) {
                blankOwnerKey = 'su'
            } else if(blankOwnerCode.equals('BSP')) {
                blankOwnerKey = 'bsp'
            } else if(blankOwnerCode.equals('Ш1')) {
                blankOwnerKey = 'tch'
            }

            if(blankOwnerKey) {

                def transportationTypeKey = null;

                if(it.transportationType == TransportationType.INTERNATIONAL || it.transportationType == TransportationType.COMBINED) {
                    transportationTypeKey = 'mvl'
                } else if(it.transportationType == TransportationType.DOMESTIC) {
                    transportationTypeKey = 'vvl'
                }

                if(transportationTypeKey) {

                    def tariffTypeKey = null;

                    if(it.tariffType == TariffType.REGULAR || it.tariffType == TariffType.GROUP) {
                        tariffTypeKey = 'regular'
                    } else if(it.tariffType == TariffType.BLOCKCHARTER) {
                        tariffTypeKey = 'block'
                    } else if(it.tariffType == TariffType.CHARTER) {
                        tariffTypeKey = 'charter'
                    }

                    if(tariffTypeKey) {
                        
                        def negate = it.status == ProductStatus.REFUND || it.status == ProductStatus.EXCHANGE;

                        totals[blankOwnerKey][transportationTypeKey][tariffTypeKey]['tariffs'] = MiscUtil.sum(totals[blankOwnerKey][transportationTypeKey][tariffTypeKey]['tariffs'], negate ? MiscUtil.negate(it.equivalentFare) : it.equivalentFare)
                        totals[blankOwnerKey][transportationTypeKey][tariffTypeKey]['taxesFuel'] = MiscUtil.sum(totals[blankOwnerKey][transportationTypeKey][tariffTypeKey]['taxesFuel'], negate ? MiscUtil.negate(it.fuelChargeAmount) : it.fuelChargeAmount)
                        totals[blankOwnerKey][transportationTypeKey][tariffTypeKey]['taxesOthers'] = MiscUtil.sum(totals[blankOwnerKey][transportationTypeKey][tariffTypeKey]['taxesOthers'], negate ? MiscUtil.negate(it.taxesSum) : it.taxesSum, negate ? it.fuelChargeAmount : MiscUtil.negate(it.fuelChargeAmount))
                        totals[blankOwnerKey][transportationTypeKey][tariffTypeKey]['commissions'] = MiscUtil.sum(totals[blankOwnerKey][transportationTypeKey][tariffTypeKey]['commissions'], negate ? MiscUtil.negate(it.vendorCommissionValue) : it.vendorCommissionValue)
                    }
                }
            }
        }
    }

    for(blankOwnerKey in blankOwnerKeys) {

        for(transportationTypeKey in transportationTypeKeys) {

            for(tariffTypeKey in tariffTypeKeys) {

                text(agency(), 'dataText|ba')
                nextColumn()
                text(code(), 'dataText|ba')
                nextColumn()
                text(agencyCity(), 'dataText|ba')
                nextColumn()
                text(year().toString(), 'dataText|ba')
                nextColumn()
                text(String.format("%02d", month().intValue()), 'dataText|ba')
                nextColumn()

                if(blankOwnerKey.equals('su')) {
                    text('на бланках авиакомпании (прямое агент. согл-е)', 'dataText|ba')
                } else if(blankOwnerKey.equals('bsp')) {
                    text('БСП', 'dataText|ba')
                } else if(blankOwnerKey.equals('tch')) {
                    text('ТКП', 'dataText|ba')
                }

                nextColumn()

                if(tariffTypeKey.equals('regular')) {
                    text('рег', 'dataText|ba')
                } else if(tariffTypeKey.equals('block')) {
                    text('блок-чарт', 'dataText|ba')
                } else if(tariffTypeKey.equals('charter')) {
                    text('чарт', 'dataText|ba')
                }

                nextColumn()

                if(transportationTypeKey.equals('mvl')) {
                    text('МВЛ', 'dataText|ba')
                } else if(transportationTypeKey.equals('vvl')) {
                    text('ВВЛ', 'dataText|ba')
                }

                nextColumn()
                number(totals[blankOwnerKey][transportationTypeKey][tariffTypeKey]['tariffs'], 'dataNumber|ba')
                nextColumn()
                number(totals[blankOwnerKey][transportationTypeKey][tariffTypeKey]['taxesFuel'], 'dataNumber|ba')
                nextColumn()
                number(totals[blankOwnerKey][transportationTypeKey][tariffTypeKey]['taxesOthers'], 'dataNumber|ba')
                nextColumn()
                number(totals[blankOwnerKey][transportationTypeKey][tariffTypeKey]['commissions'], 'dataNumber|ba')
                nextRow()
            }
        }
    }

    text('Итого', 'rowHeader|ahl|ba', 4 , 1)
    4.times{nextColumn()}

    4.times{

        text(null, 'dataText|ba')
        nextColumn()
    }

    4.times{

        formula("SUM(${cellIndex(-18, 0)}:${cellIndex(-1, 0)})", 'dataNumber|ba')
        nextColumn()
    }
}
