﻿<%@ page errorPage="../../../error.jsp" pageEncoding="UTF-8"
	contentType="text/html; charset=UTF-8"
	import="com.gridnine.xtrip.server.parsers.utils.DBVolumeWorker"
	import=" com.gridnine.xtrip.common.model.system.Message"
	import=" com.gridnine.xtrip.common.model.system.MessageType"
%>
<%
	boolean onlyRefresh = true;
	request.setCharacterEncoding("utf-8");
	if (request.getParameter("stop") != null) {
	    DBVolumeWorker.get().stop();
	    onlyRefresh = false;
	} else if (request.getParameter("start") != null) {
	    DBVolumeWorker.get().test(request.getParameter("config"),
	            (String) request.getSession().getAttribute("auth.l"),
	            (char[])request.getSession().getAttribute("auth.p"));
	} else if (request.getParameter("reset") != null) {
	    DBVolumeWorker.get().reset();
	    onlyRefresh = false;
	} else if(request.getParameter("load") != null) {
		response.setContentType("application/vnd.ms-excel");
		DBVolumeWorker.get().fillExcelData(response.getOutputStream());
	    onlyRefresh = false;
		return;
	}
%>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<head>
<title>DB volume stress test page</title>
<%--meta http-equiv="refresh" content="30;url=debug.jsp"--%>
</head>
<body>
<h1>DB volume stress test page</h1>
<%
	if (onlyRefresh) {
%>
<META HTTP-EQUIV="REFRESH" CONTENT="20">
<%
	}
%>
<div id="controls">
<%
	if (!onlyRefresh && !DBVolumeWorker.get().isStarted()) {
%>
<fieldset><legend><strong>Task parameters</strong></legend>
<p>
<form method="post">
<p><textarea rows="50" cols="100" name="config" value="Insert config"></textarea></p>
<p><input type="submit" name="start" value="Start" /></p>
</form>
</p>
</fieldset>
<%
	} else if (onlyRefresh
			|| (DBVolumeWorker.get().isStarted() && !DBVolumeWorker.get().isCompleted())) {
%>
<fieldset>
<legend><strong><%=String.format("Импортировано %s объектов из %s (%s%%) за %s часов", DBVolumeWorker.get().getProcessedEntitiesCount(), DBVolumeWorker.get().getTotalEntitiesCount(), DBVolumeWorker.get().getProgress(), Math.round((System.currentTimeMillis() - DBVolumeWorker.get().getStartTime())/(3600 * 10))/((double) 100))%></strong></legend>
<p>
<form method="post"><input type="submit" name="refresh"
	value="Refresh" /> <input type="submit" name="stop" value="Stop" /> <input type="submit" name="load" value="Load" /></form>
</p>
</fieldset>
<%
	} else {
%>
<fieldset>
<p>
<form method="post"><input type="submit" name="reset"
	value="Reset" /> <input type="submit" name="load"
	value="Load" /></form>
</p>
</fieldset>
<%
	}
%>
</div>
<h3>Messages</h3>
<div id="messages">
<table align="center" width="90%" border="1" cellspacing="0"
	cellpadding="5">
	<tr>
		<th>Status</th>
		<th>Message</th>
		<th>Details</th>
	</tr>
	<%
		for (Message message : DBVolumeWorker.get().getMessages()) {
	%>
	<tr>
		<td><%=message.getType().toString()%></td>
		<td><%=message.getMessage().toString()%>&nbsp;</td>
		<td><%=message.getDetails()%></td>
	</tr>
	<%
		}
	%>
</table>
</div>
</body>
</html>
