package com.gridnine.xtrip.server.support.model.questionnaire.scripts

import com.gridnine.xtrip.common.Environment
import com.gridnine.xtrip.common.model.dict.Airline
import com.gridnine.xtrip.common.model.dict.CodeSystem
import com.gridnine.xtrip.common.model.dict.DictionaryCache
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.profile.OrganizationIndex
import com.gridnine.xtrip.common.model.questionnaire.RegisterAnswerSyncRequest
import com.gridnine.xtrip.common.reports.model.SalesReportDocumentIndex
import com.gridnine.xtrip.common.search.Projection
import com.gridnine.xtrip.common.search.ProjectionQuery
import com.gridnine.xtrip.common.search.SearchCriterion
import com.gridnine.xtrip.common.search.SearchQuery
import com.gridnine.xtrip.common.search.SortOrder
import com.gridnine.xtrip.common.xml.XSUtil
import org.apache.commons.io.FileUtils

if(Environment.getApplicationId().startsWith("vip-")){
    return;
}

//def answer = new RegisterAnswerSyncRequest();
Date lastUseDate = null
def airlines = DictionaryCache.get().lookup(Airline.class, "U6", CodeSystem.IATA.name())
if(!airlines.isEmpty()){
    def orgCtr = EntityStorage.get().find(OrganizationIndex.class, OrganizationIndex.Property.airline.name(), airlines[0].toReference())
    if(orgCtr){
        def orgRef = orgCtr.toReference();
        def query = new SearchQuery();
        query.preferredProperties.add("containerUid")
        query.criteria.orders.put(SalesReportDocumentIndex.Property.created.name(), SortOrder.DESC);
        for(def idx: EntityStorage.get().search(SalesReportDocumentIndex.class, query).getData()){
           def repCtr = EntityStorage.get().resolve(idx.source)
            if(repCtr){
                if(orgRef.equals(repCtr.entity.parameters.blankOwner)){
                    lastUseDate = repCtr.created;
                    break;
                }
            }
        }
    }
}


answer.textData = Environment.getApplicationId()+": " +(lastUseDate ? "last use is " + lastUseDate: "not used")
answer.booleanData = lastUseDate != null


//String serialized = XSUtil.toString(answer)
//FileUtils.write(new File(Environment.tempFolder, "answer.txt"), serialized)
