//file:noinspection SpellCheckingInspection
package com.gridnine.xtrip.server.support.model.stats

import com.gridnine.xtrip.common.model.EntityReference
import com.gridnine.xtrip.common.model.asset.AssetsStorage
import com.gridnine.xtrip.common.model.booking.commission.ProductType
import com.gridnine.xtrip.common.model.booking.statistics.ProductBillingDataChangeDataSource
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.search.Projection
import com.gridnine.xtrip.common.search.ProjectionQuery
import com.gridnine.xtrip.common.search.SearchCriterion
import com.gridnine.xtrip.common.support.model.licence2.MomLicenceCard
import com.gridnine.xtrip.common.support.model.stats.*
import com.gridnine.xtrip.common.util.MiscUtil

createStyle(name: 'header', fontBold: false, foreground: "GREY_25_PERCENT", h_alignment: 'CENTER', v_alignment: 'CENTER',
        fontHeight: 10, leftBorder: 'MEDIUM', rightBorder: 'MEDIUM', topBorder: 'MEDIUM', bottomBorder: 'MEDIUM', wrapText: true)
createStyle(name: 'data', fontBold: false, h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight: 10, leftBorder: 'THIN',
        rightBorder: 'THIN', topBorder: 'THIN', bottomBorder: 'THIN')
createStyle(name: 'textData', parent: 'data')
createStyle(name: 'numberData', parent: 'data', h_alignment: 'RIGHT')

class RplEntry {
   String customerCode
   int count
   String agencyName
   BigDecimal price
}

Map<String, RplEntry> entries = [:]

ProjectionQuery pq = new ProjectionQuery()
if (parameters.startDate != null) {
    pq.getCriteria().getCriterions().add(SearchCriterion.ge(
            ProductStatistics.Property.issueDate.name(), MiscUtil.clearTime(parameters.startDate)))
}
if (parameters.endDate != null) {
    pq.getCriteria().getCriterions().add(SearchCriterion.le(
            ProductStatistics.Property.issueDate.name(), MiscUtil.setDayEndTime(parameters.endDate)))
}

ProductStatisticsActionSourceRef sourceRef = AssetsStorage.get().load(
        ProductStatisticsActionSourceRef.class, ProductBillingDataChangeDataSource.CLIENT.name())
ProductStatisticsProductTypeRef additionalServiceTypeRef = AssetsStorage.get().load(
        ProductStatisticsProductTypeRef.class, ProductType.ADDITIONAL_SERVICE.name())
if (sourceRef != null) {
    pq.getCriteria().getCriterions().add(SearchCriterion.or(
            SearchCriterion.eq(ProductStatistics.Property.actionSourceId.name(), null),
            SearchCriterion.or(
                    SearchCriterion.ne(ProductStatistics.Property.actionSourceId.name(), sourceRef.getId()),
                    SearchCriterion.and(
                            SearchCriterion.eq(ProductStatistics.Property.productTypeId.name(), additionalServiceTypeRef.getId()),
                            SearchCriterion.eq(ProductStatistics.Property.hasUsedCoupons.name(), Boolean.TRUE),
                    ))
    ))
}

ProductStatisticsStatusRef statRef = AssetsStorage.get().load(ProductStatisticsStatusRef.class, "INTENTION")
ProductStatisticsStatusRef voidIntentionRef = AssetsStorage.get().load(ProductStatisticsStatusRef.class, "VOID_INTENTION")
if (statRef != null) {
    if (voidIntentionRef != null) {
        pq.getCriteria().getCriterions().add(SearchCriterion.or(
                SearchCriterion.eq(ProductStatistics.Property.statusId.name(), null),
                SearchCriterion.and(
                        SearchCriterion.ne(ProductStatistics.Property.statusId.name(), statRef.getId()),
                        SearchCriterion.ne(ProductStatistics.Property.statusId.name(), voidIntentionRef.getId())
                )
        ))
    } else {
        pq.getCriteria().getCriterions().add(SearchCriterion.or(
                SearchCriterion.eq(ProductStatistics.Property.statusId.name(), null),
                SearchCriterion.ne(ProductStatistics.Property.statusId.name(), statRef.getId()))
        )
    }
}

if (parameters.license != null && !parameters.license.isEmpty()) {
    List<Short> ids = new ArrayList<>()
    parameters.license.forEach { EntityReference<MomLicenceCard> licenseRef ->
        ProductStatisticsLicenseRef license = AssetsStorage.get()
                .load(ProductStatisticsLicenseRef.class, licenseRef.getUid())
        if (license != null) {
            ids.add(license.id)
        } else if (ids.isEmpty()) {
            ids.add(-1 as Short)
        }
    }
    pq.getCriteria().getCriterions().add(SearchCriterion.in(
            ProductStatistics.Property.licenseId.name(), ids.toArray(new short[ids.size()])))
}

pq.getCriteria().getCriterions().add(SearchCriterion.eq(
        ProductStatistics.Property.modifiedAfterFreezeDate.name(), Boolean.FALSE))

pq.projections.add(Projection.group(ProductStatistics.Property.licenseId.name(), "_license"))
pq.projections.add(Projection.count(ProductStatistics.Property.productTypeId.name(), "_count"))
pq.projections.add(Projection.group(ProductStatistics.Property.productTypeId.name(), "_type"))
pq.projections.add(Projection.group(ProductStatistics.Property.gdsId.name(), "_gds"))

def data = AssetsStorage.get().search(ProductStatistics.class, pq).getData()
def defaultPrice = parameters.price
data.each { Map<String, Object> entry ->
    int count = entry.get("_count") as int
    byte type = entry.get("_type") as byte
    byte gds = entry.get("_gds") as byte
    short licence = entry.get("_license") as short
    def typeRef = AssetsStorage.get().find(
            ProductStatisticsProductTypeRef.class, ProductStatisticsProductTypeRef.Property.id.name(), type)
    if (typeRef != null && "UNKNOWN" == typeRef.uid) {
        return
    }
    def gdsRef = AssetsStorage.get().find(
            ProductStatisticsGdsRef.class, ProductStatisticsGdsRef.Property.id.name(), gds)
    if (gdsRef != null && "UNKNOWN" == gdsRef.uid) {
        return
    }
    if (gdsRef != null && gdsRef.uid.startsWith("SABRE")) {
        return
    }
    if (typeRef != null && "INSURANCE_ACCIDENT" == typeRef.uid && gdsRef != null && "GABRIEL" == gdsRef.uid) {
        return
    }
    if (typeRef != null && "MISC_PRODUCT" == typeRef.uid) {
        return
    }
    if (typeRef != null && "EXCESS_BAGAGE" == typeRef.uid) {
        return
    }
    if (typeRef != null && "PRODUCT_VOIDING" == typeRef.uid) {
        return
    }
    def licenseRef = AssetsStorage.get().find(
            ProductStatisticsLicenseRef.class, ProductStatisticsLicenseRef.Property.id.name(), licence)

    def rplEntry = entries[licenseRef.caption]
    if (rplEntry == null) {
        rplEntry = new RplEntry()
        rplEntry.agencyName = licenseRef.caption
        def licenceCtr = EntityStorage.get().load(MomLicenceCard.class, licenseRef.uid)
        rplEntry.customerCode = licenceCtr.entity.customerNumber
        if (licenceCtr.entity.customerName != null) {
            rplEntry.agencyName = licenceCtr.entity.customerName
        }
        if (licenceCtr.entity.transactionPrice != null) {
            rplEntry.price = licenceCtr.entity.transactionPrice
        } else {
            rplEntry.price = defaultPrice
        }
        entries[licenseRef.caption] = rplEntry
    }
    entries[licenseRef.caption].count = entries[licenseRef.caption].count + count
}

def rplEntries = new ArrayList<>(entries.values())
rplEntries.sort { Object o1, Object o2 ->
    return MiscUtil.compare(((RplEntry) o1).customerCode, ((RplEntry) o2).customerCode)
}

def cal = Calendar.getInstance()
cal.setTime(parameters.startDate)
def quoter
def months
//noinspection GroovyFallthrough
switch (cal.get(Calendar.MONTH)) {
    case Calendar.JANUARY:
    case Calendar.FEBRUARY:
    case Calendar.MARCH:
        quoter = 1
        months = "JAN-MAR"
        break
    case Calendar.APRIL:
    case Calendar.MAY:
    case Calendar.JUNE:
        quoter = 2
        months = "APR-JUN"
        break
    case Calendar.JULY:
    case Calendar.AUGUST:
    case Calendar.SEPTEMBER:
        quoter = 3
        months = "JUL-SEP"
        break
    default:
        months = "OCT-DEC"
        quoter = 4
        break
}
def customerMaterialNumber = "${months} Q${quoter} ${cal.get(Calendar.YEAR) - 2000}"
def materialNumber = "SVRPLVARIABLE"
def itemDescription = "Russian Product Line"
def pricingCurrency = "USD"

page { "Ticketing Fee" } {
    columnWidth(20); text('Customer Number', 'header'); nextColumn()
    columnWidth(20); text('Material Number', 'header'); nextColumn()
    columnWidth(30); text('Item Description', 'header'); nextColumn()
    columnWidth(20); text('Quantity', 'header'); nextColumn()
    columnWidth(20); text('Price', 'header'); nextColumn()
    columnWidth(20); text('Sequence', 'header'); nextColumn()
    columnWidth(20); text('Customer Material Number', 'header'); nextColumn()
    columnWidth(20); text('Pricing Currency', 'header'); nextColumn()
    columnWidth(20); text('Agency Name', 'header')

    rplEntries.forEach { entry ->
        nextRow()
        text(entry.customerCode, 'textData'); nextColumn()
        text(materialNumber, 'textData'); nextColumn()
        text(itemDescription, 'textData'); nextColumn()
        number(entry.count, 'numberData'); nextColumn()
        number(entry.price, 'numberData'); nextColumn()
        text("", 'textData'); nextColumn()
        text(customerMaterialNumber, 'textData'); nextColumn()
        text(pricingCurrency, 'textData'); nextColumn()
        text(entry.agencyName, 'textData')
    }
}
setDefaultSheet("Ticketing Fee")
