import com.gridnine.xtrip.common.model.EntityContainer
import com.gridnine.xtrip.common.model.EntityReference
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.Environment
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.search.SearchCriterion
import com.gridnine.xtrip.common.search.SearchQuery
import com.gridnine.xtrip.common.search.SortOrder
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper
import com.gridnine.xtrip.common.util.TextUtil
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentRecordIndex;
import com.gridnine.xtrip.common.model.profile.BankAccount;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import java.util.stream.Collectors
import java.util.Calendar;
import groovy.transform.Field
import org.apache.commons.lang.time.FastDateFormat


@Field String fileSuffix = FastDateFormat.getInstance("yyyy.MM.dd_HH.mm").format(new Date())
@Field FastDateFormat DTF = FastDateFormat.getInstance("dd.MM.yyyy HH:mm")

@Field boolean onlyLook = true

if (onlyLook) {
    fileMessage("Режим 'Только просмотр' ")
}

doJob()

void doJob() {

    int errors = 0

    String result = ""

    try {
            List<String> customerCodes = Arrays.asList(
                "CL4783", "CL4777", "CL4784", "CL4782", "CL4781", "CL4786", "CL4780", "CL4779", "CL4785", "CL4778")

            SearchQuery customersQuery = new SearchQuery()
            customersQuery.getCriteria().getCriterions()
                    .add(SearchQueryHelper.buildOrEqStringCriterion(
                            OrganizationIndex.Property.code.name(), customerCodes))
            customersQuery.getCriteria().getCriterions()
                    .add(SearchCriterion.contains(
                            OrganizationIndex.Property.types.name(), OrganizationType.CORPORATE_CLIENT))
            List<OrganizationIndex> customerIndices = EntityStorage.get()
                    .search(OrganizationIndex.class, customersQuery).getData()

            Set<EntityReference<Organization>> customers = customerIndices.stream()
                    .map({item -> item.getSource()})
                    .collect(Collectors.toSet())

            EntityContainer<Organization> supplierCtr = EntityStorage.get().load(
                    Organization.class, "a4e25c11-a717-4fe2-8ef5-96ace2904d3d")

            if (supplierCtr != null) {
                EntityReference<Organization> supplier = supplierCtr.toReference()
                String accountUid = "3f1ae550-277e-4c46-9391-b71e4580b060"

                SearchQuery query = new SearchQuery()
                Calendar calendar = Calendar.getInstance()
                calendar.set(2023, Calendar.FEBRUARY, 15, 23, 59, 59)
                Date date = calendar.getTime()

                query.getCriteria().getCriterions()
                        .add(SearchCriterion.eq(
                                FinanceDocumentRecordIndex.Property.supplier.name(), supplier))
                query.getCriteria().getCriterions()
                        .add(SearchQueryHelper.buildOrEqEntityCriterion(
                                FinanceDocumentRecordIndex.Property.customer.name(), customers))
                query.getCriteria().getCriterions()
                        .add(SearchCriterion.ge(
                                FinanceDocumentRecordIndex.Property.date.name(), date))

                List<EntityContainer<FinanceDocument>> documents = EntityStorage.get()
                        .search(FinanceDocumentRecordIndex.class, query)
                        .getData().stream()
                        .map({item -> EntityStorage.get().resolve(item.getSource())})
                        .filter({item -> item != null})
                        .collect(Collectors.toList())

                BankAccount bankAccount = supplierCtr.getEntity()
                        .getBankAccounts().stream()
                        .filter({item -> item.getUid().equals(accountUid)})
                        .findFirst().orElse(null)

                StringBuilder builder = new StringBuilder()
                int count = 0
                if (bankAccount != null) {
                    NestedEntityReference<Organization, BankAccount> supplierBankAccount =
                            new NestedEntityReference<>(supplier, bankAccount)
                    for (EntityContainer<FinanceDocument> document : documents) {
                        if (document.getEntity().getSupplierBankAccount() != null &&
                                !document.getEntity().getSupplierBankAccount().getNestedEntityUid().equals(accountUid)) {
                            if (builder.length() != 0) {
                                builder.append("\n")
                            }
                            builder.append(String.format("%s\t%s\t%s", document.getEntity().getName(),
                                    document.getEntity().getCustomer(),
                                    document.getEntity().getSupplierBankAccount() != null ?
                                            document.getEntity().getSupplierBankAccount().getCaption() : "null"))
                            if (!onlyLook) {
                                    document.getEntity().setSupplierBankAccount(supplierBankAccount);
                                    document.getVersionInfo().setDataSource("updateBankAccount_TUIBT2326")
                                    EntityStorage.get().save(document, true)
                            }
                            count++
                        }
                    }
                }

                result = String.format(
                    "%s %s документов с неактуальным расчетным счетом поставщика за период %s - %s для клиентов:\n%s:\n\n%s",
                        onlyLook ? "Найдено" : "Обновлено",
                        count,
                        DTF.format(date),
                        DTF.format(new Date()),
                        customers.stream().map({item -> item.getCaption()}).collect(Collectors.joining(", ")),
                        builder)
            }
    } catch (Exception ex) {
        errors++
        fileMessage("${TextUtil.getExceptionStackTrace(ex)}", false)
    }

    fileMessage("")
    fileMessage("\n${result}")
    fileMessage("Итого возникло ${errors} ошибок")
}

void fileMessage(String str){
    fileMessage(str, true)
}

void fileMessage(String str, boolean writeToConsole){
    if (writeToConsole){
        message(str)
    }
    new File(Environment.getRootFolder(), "/logs/TUIBT2326_${fileSuffix}.txt")
            .append("${DTF.format(new Date())}: ${str} \n")
}