/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.tools.mocks;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.java.plugin.PathResolver;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.IntegrityCheckReport;
import org.java.plugin.registry.ManifestInfo;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginFragment;
import org.java.plugin.registry.PluginRegistry;
import org.java.plugin.registry.Version;
import org.java.plugin.registry.xml.PluginRegistryImpl;
import org.java.plugin.util.ExtendedProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockPluginRegistry
implements PluginRegistry {
    private IntegrityCheckReport integrityCheckReport;
    private PluginRegistryImpl xmlRegistryImpl;
    private LinkedList<PluginRegistry.RegistryChangeListener> listeners = new LinkedList();
    private IntegrityCheckReport registrationReport;
    private HashMap<String, ExtensionPoint> extensionPoints = new HashMap();
    private HashMap<String, PluginDescriptor> pluginDescriptors = new HashMap();
    private LinkedList<PluginFragment> pluginFragments = new LinkedList();

    @Override
    public IntegrityCheckReport checkIntegrity(PathResolver pathResolver) {
        return this.integrityCheckReport;
    }

    @Override
    public IntegrityCheckReport checkIntegrity(PathResolver pathResolver, boolean includeRegistrationReport) {
        return this.integrityCheckReport;
    }

    public MockPluginRegistry setIntegrityCheckReport(IntegrityCheckReport value) {
        this.integrityCheckReport = value;
        return this;
    }

    @Override
    public void configure(ExtendedProperties config) {
    }

    @Override
    public String extractId(String uniqueId) {
        if (this.xmlRegistryImpl == null) {
            this.xmlRegistryImpl = new PluginRegistryImpl();
        }
        return this.xmlRegistryImpl.extractId(uniqueId);
    }

    @Override
    public String extractPluginId(String uniqueId) {
        if (this.xmlRegistryImpl == null) {
            this.xmlRegistryImpl = new PluginRegistryImpl();
        }
        return this.xmlRegistryImpl.extractPluginId(uniqueId);
    }

    @Override
    public Version extractVersion(String uniqueId) {
        if (this.xmlRegistryImpl == null) {
            this.xmlRegistryImpl = new PluginRegistryImpl();
        }
        return this.xmlRegistryImpl.extractVersion(uniqueId);
    }

    @Override
    public Collection<PluginDescriptor> getDependingPlugins(PluginDescriptor descr) {
        return Collections.emptyList();
    }

    @Override
    public ExtensionPoint getExtensionPoint(String pluginId, String pointId) {
        String uid = this.makeUniqueId(pluginId, pointId);
        ExtensionPoint result = this.extensionPoints.get(uid);
        if (result == null) {
            throw new IllegalArgumentException("unknown extenssion point UID " + uid);
        }
        return result;
    }

    @Override
    public ExtensionPoint getExtensionPoint(String uniqueId) {
        ExtensionPoint result = this.extensionPoints.get(uniqueId);
        if (result == null) {
            throw new IllegalArgumentException("unknown extenssion point UID " + uniqueId);
        }
        return result;
    }

    public MockPluginRegistry addExtensionPoint(ExtensionPoint extPoint) {
        this.extensionPoints.put(extPoint.getUniqueId(), extPoint);
        return this;
    }

    @Override
    public PluginDescriptor getPluginDescriptor(String pluginId) {
        PluginDescriptor result = this.pluginDescriptors.get(pluginId);
        if (result == null) {
            throw new IllegalArgumentException("unknown plug-in ID " + pluginId);
        }
        return result;
    }

    @Override
    public Collection<PluginDescriptor> getPluginDescriptors() {
        return Collections.unmodifiableCollection(this.pluginDescriptors.values());
    }

    public MockPluginRegistry addPluginDescriptor(PluginDescriptor descr) {
        this.pluginDescriptors.put(descr.getId(), descr);
        return this;
    }

    @Override
    public Collection<PluginFragment> getPluginFragments() {
        return Collections.unmodifiableCollection(this.pluginFragments);
    }

    public MockPluginRegistry addPluginFragment(PluginFragment fragment) {
        this.pluginFragments.add(fragment);
        return this;
    }

    @Override
    public IntegrityCheckReport getRegistrationReport() {
        return this.registrationReport;
    }

    public MockPluginRegistry setRegistrationReport(IntegrityCheckReport value) {
        this.registrationReport = value;
        return this;
    }

    @Override
    public boolean isExtensionPointAvailable(String pluginId, String pointId) {
        return this.extensionPoints.containsKey(this.makeUniqueId(pluginId, pointId));
    }

    @Override
    public boolean isExtensionPointAvailable(String uniqueId) {
        return this.extensionPoints.containsKey(uniqueId);
    }

    @Override
    public boolean isPluginDescriptorAvailable(String pluginId) {
        return this.pluginDescriptors.containsKey(pluginId);
    }

    @Override
    public String makeUniqueId(String pluginId, String elementId) {
        if (this.xmlRegistryImpl == null) {
            this.xmlRegistryImpl = new PluginRegistryImpl();
        }
        return this.xmlRegistryImpl.makeUniqueId(pluginId, elementId);
    }

    @Override
    public String makeUniqueId(String pluginId, Version version) {
        if (this.xmlRegistryImpl == null) {
            this.xmlRegistryImpl = new PluginRegistryImpl();
        }
        return this.xmlRegistryImpl.makeUniqueId(pluginId, version);
    }

    @Override
    public ManifestInfo readManifestInfo(URL manifest) {
        return null;
    }

    @Override
    public Map<String, Identity> register(URL[] manifests) {
        return Collections.emptyMap();
    }

    @Override
    public void registerListener(PluginRegistry.RegistryChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public Collection<String> unregister(String[] ids) {
        return Collections.emptyList();
    }

    @Override
    public void unregisterListener(PluginRegistry.RegistryChangeListener listener) {
        this.listeners.remove(listener);
    }
}

