/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.ex;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.PathResolver;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.Library;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginRegistry;
import org.java.plugin.util.IoUtil;

public class EnhancedPluginClassLoader
extends PluginClassLoader {
    static Log log = LogFactory.getLog(EnhancedPluginClassLoader.class);
    private static File libCacheFolder;
    private static boolean libCacheFolderInitialized;
    private Map<String, File> libraryCache = new HashMap<String, File>();

    private static URL[] getUrls(PluginManager manager) {
        PluginRegistry registry = manager.getRegistry();
        LinkedList<URL> urls = new LinkedList<URL>();
        for (PluginDescriptor descr : registry.getPluginDescriptors()) {
            URL[] pluginURLs;
            for (URL url : pluginURLs = EnhancedPluginClassLoader.getUrls(manager, descr)) {
                urls.add(url);
            }
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private static URL[] getUrls(PluginManager manager, PluginDescriptor descr) {
        LinkedList<URL> result = new LinkedList<URL>();
        for (Library lib : descr.getLibraries()) {
            result.add(manager.getPathResolver().resolvePath((Identity)lib, lib.getPath()));
        }
        if (log.isDebugEnabled()) {
            StringBuilder buf = new StringBuilder();
            buf.append("Code URL's populated for plug-in " + descr + ":\r\n");
            for (Object e : result) {
                buf.append("\t");
                buf.append(e);
                buf.append("\r\n");
            }
            log.debug((Object)buf.toString());
        }
        return result.toArray(new URL[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getLibCacheFolder() {
        if (libCacheFolder != null) {
            return libCacheFolderInitialized ? libCacheFolder : null;
        }
        Class<EnhancedPluginClassLoader> clazz = EnhancedPluginClassLoader.class;
        synchronized (EnhancedPluginClassLoader.class) {
            libCacheFolder = new File(System.getProperty("java.io.tmpdir"), System.currentTimeMillis() + ".jpf-lib-cache");
            log.debug((Object)("libraries cache folder is " + libCacheFolder));
            File lockFile = new File(libCacheFolder, "lock");
            if (lockFile.exists()) {
                log.error((Object)("can't initialize libraries cache folder " + libCacheFolder + " as lock file indicates that it" + " is owned by another JPF instance"));
                // ** MonitorExit[var0] (shouldn't be in output)
                return null;
            }
            if (libCacheFolder.exists()) {
                IoUtil.emptyFolder((File)libCacheFolder);
            } else {
                libCacheFolder.mkdirs();
            }
            try {
                if (!lockFile.createNewFile()) {
                    log.error((Object)("can't create lock file in JPF libraries cache folder " + libCacheFolder));
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return null;
                }
            }
            catch (IOException ioe) {
                log.error((Object)("can't create lock file in JPF libraries cache folder " + libCacheFolder), (Throwable)ioe);
                // ** MonitorExit[var0] (shouldn't be in output)
                return null;
            }
            lockFile.deleteOnExit();
            libCacheFolder.deleteOnExit();
            libCacheFolderInitialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return libCacheFolder;
        }
    }

    public EnhancedPluginClassLoader(PluginManager aManager, ClassLoader parent) {
        super(aManager, null, EnhancedPluginClassLoader.getUrls(aManager), parent);
    }

    public URL checkResource(String name) {
        try {
            Enumeration urls = super.getResources(name);
            if (urls.hasMoreElements()) {
                URL first = (URL)urls.nextElement();
                if (urls.hasMoreElements()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(first.toString());
                    while (urls.hasMoreElements()) {
                        URL url = (URL)urls.nextElement();
                        sb.append(", ").append(url.toString());
                    }
                    StackTraceElement element = null;
                    StackTraceElement[] traces = Thread.currentThread().getStackTrace();
                    int count = traces.length;
                    for (int index = 2; index < count && ((element = traces[index]).getClassName().startsWith("java.lang") || element.getClassName().startsWith("org.java.plugin")); ++index) {
                    }
                    if (name != null && !name.endsWith("/")) {
                        log.warn((Object)("MORE THAN ONE RESOURCE FOUND: " + (name != null ? name : "(null)") + (element != null ? " (" + element.getClassName() + "." + element.getMethodName() + ")" : "") + "[" + sb.toString() + "]"));
                        if (name.startsWith("com/gridnine/")) {
                            throw new IllegalStateException("More than one resource found: " + name);
                        }
                    }
                }
                return first;
            }
            return null;
        }
        catch (IOException iOException) {
            return super.getResource(name);
        }
    }

    public URL getResource(String name) {
        URL result = this.checkResource(name);
        if (result != null || name.endsWith("/")) {
            return result;
        }
        return this.checkResource(name + "/");
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration urls = super.findResources(name);
        if (urls.hasMoreElements() || name.endsWith("/")) {
            return urls;
        }
        return super.findResources(name + "/");
    }

    protected void pluginsSetChanged() {
    }

    protected void dispose() {
        for (File file : this.libraryCache.values()) {
            file.delete();
        }
        this.libraryCache.clear();
    }

    protected String findLibrary(String name) {
        if (name == null || "".equals(name.trim())) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("findLibrary(String): name=" + name + ", this=" + (Object)((Object)this)));
        }
        String libname = System.mapLibraryName(name);
        String result = null;
        PathResolver pathResolver = this.getPluginManager().getPathResolver();
        PluginRegistry registry = this.getPluginManager().getRegistry();
        block0: for (PluginDescriptor descr : registry.getPluginDescriptors()) {
            for (Library lib : descr.getLibraries()) {
                File libFile;
                if (lib.isCodeLibrary()) continue;
                URL libUrl = pathResolver.resolvePath((Identity)lib, lib.getPath() + libname);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("findLibrary(String): trying URL " + libUrl));
                }
                if ((libFile = IoUtil.url2file((URL)libUrl)) != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("findLibrary(String): URL " + libUrl + " resolved as local file " + libFile));
                    }
                    if (!libFile.isFile()) continue;
                    result = libFile.getAbsolutePath();
                    continue block0;
                }
                String libraryCacheKey = libUrl.toExternalForm();
                libFile = this.libraryCache.get(libraryCacheKey);
                if (libFile != null) {
                    if (libFile.isFile()) {
                        result = libFile.getAbsolutePath();
                        continue block0;
                    }
                    this.libraryCache.remove(libraryCacheKey);
                }
                if (this.libraryCache.containsKey(libraryCacheKey)) continue block0;
                libFile = this.cacheLibrary(libUrl, libname, descr);
                if (libFile == null) continue;
                result = libFile.getAbsolutePath();
                continue block0;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("findLibrary(String): name=" + name + ", libname=" + libname + ", result=" + result + ", this=" + (Object)((Object)this)));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized File cacheLibrary(URL libUrl, String libname, PluginDescriptor descr) {
        String libraryCacheKey = libUrl.toExternalForm();
        File result = this.libraryCache.get(libraryCacheKey);
        if (result != null) {
            return result;
        }
        try {
            File cacheFolder = EnhancedPluginClassLoader.getLibCacheFolder();
            if (cacheFolder == null) {
                throw new IOException("can't initialize libraries cache folder");
            }
            File libCachePluginFolder = new File(cacheFolder, descr.getUniqueId());
            if (!libCachePluginFolder.exists() && !libCachePluginFolder.mkdirs()) {
                throw new IOException("can't create cache folder " + libCachePluginFolder);
            }
            result = new File(libCachePluginFolder, libname);
            try (InputStream in = IoUtil.getResourceInputStream((URL)libUrl);
                 BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(result));){
                IoUtil.copyStream((InputStream)in, (OutputStream)out, (int)512);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("library " + libname + " successfully cached from URL " + libUrl + " and saved to local file " + result));
            }
        }
        catch (IOException ioe) {
            log.error((Object)("can't cache library " + libname + " from URL " + libUrl), (Throwable)ioe);
            result = null;
        }
        this.libraryCache.put(libraryCacheKey, result);
        return result;
    }

    static {
        ClassLoader.registerAsParallelCapable();
        libCacheFolderInitialized = false;
    }
}

