<%@page import="com.gridnine.xtrip.server.gds.sabre.SabreSession.TraceItem"%>
<%@page import="java.util.Collection"%>
<%@page import="com.gridnine.xtrip.common.util.MiscUtil"%>
<%@page import="java.util.Comparator"%>
<%@page import="java.util.Collections"%>
<%@page import="java.util.LinkedList"%>
<%@page import="java.util.List"%>
<%@page import="org.apache.commons.codec.digest.DigestUtils"%>
<%@page import="com.google.common.base.Function"%>
<%@page import="com.google.common.collect.Multimap"%>
<%@page import="com.google.common.collect.Multimaps"%>
<%@page import="java.util.HashSet"%>
<%@page import="com.gridnine.xtrip.server.gds.sabre.SabreSession"%>
<%@page import="java.util.Set"%>
<%@page import="com.gridnine.xtrip.server.gds.sabre.SimpleSabreSessionManager"%>
<%@page import="com.gridnine.xtrip.common.gds.model.GDSParameters"%>
<%@page import="com.gridnine.xtrip.server.gds.sabre.SabreGDSConnector"%>
<%@page import="com.gridnine.xtrip.common.model.dict.GdsName"%>
<%@page import="com.gridnine.xtrip.server.gds.GDSConnectorRegistry"%>
<%@page import="com.gridnine.xtrip.common.Environment"%>
<html>
<head>
	<script>
	function toggle(name) {
		var el = document.getElementById(name);
		el.style.display = (el.style.display == 'none') ? '' : 'none';
	}
	</script>
</head>
<body>
	<h1>Sabre Sessions</h1>
	<%
	SabreGDSConnector connector = (SabreGDSConnector) Environment.getPublished(GDSConnectorRegistry.class).get(GdsName.SABRE);
	GDSParameters gdsParameters = new GDSParameters();
	gdsParameters.setPrimaryPCC(request.getParameter("ipcc"));
	SimpleSabreSessionManager manager = (SimpleSabreSessionManager) connector.getSessionManager(gdsParameters);
	final Multimap<String, SabreSession> active = Multimaps.index(manager.getSessions().values(),
			new Function<SabreSession, String>() {
		@Override
		public String apply(SabreSession ss) {
			if (ss.getTraces().size() > 0) {
				return DigestUtils.md5Hex(ss.getTraces().get(0).data);
			} else {
				return "no-trace";
			}
		}
	});
	final Multimap<String, SabreSession> onhold = Multimaps.index(manager.getOnHold().values(),
			new Function<SabreSession, String>() {
		@Override
		public String apply(SabreSession ss) {
			if (ss.getTraces().size() > 0) {
				return DigestUtils.md5Hex(ss.getTraces().get(0).data);
			} else {
				return "no-trace";
			}
		}
	});
	List<String> keys = new LinkedList<String>();
	keys.addAll(active.keySet());
	keys.addAll(onhold.keySet());
	// sort by total count desc
	Collections.sort(keys, new Comparator<String>() {
		@Override
		public int compare(String k1, String k2) {
			return - MiscUtil.compare(Integer.valueOf(getTotal(k1)), Integer.valueOf(getTotal(k2)));
		}
		
		private int getTotal(String key) {
			Collection<SabreSession> valActive = active.get(key);
			Collection<SabreSession> valOnhold = onhold.get(key);
			int res = 0;
			if (valActive != null) {
				res += valActive.size();
			}
			if (valOnhold != null) {
				res += valOnhold.size();
			}
			return res;
		}
	});
	%>
	<table border="1">
	<tr>
		<th>trace hash</th>
		<th>active</th>
		<th>onhold</th>
		<th>total</th>
	</tr>
	<% for (String key : keys) {
		Collection<SabreSession> valActive = active.get(key);
		Collection<SabreSession> valOnhold = onhold.get(key);
		List<SabreSession> sessions = new LinkedList<SabreSession>();
		int activeQty = 0;
		int onholdQty = 0;
		if (valActive != null) {
			activeQty += valActive.size();
			sessions.addAll(valActive);
		}
		if (valOnhold != null) {
			onholdQty += valOnhold.size();
			sessions.addAll(valOnhold);
		}
		int totalQty = activeQty + onholdQty;
		Collections.sort(sessions, new Comparator<SabreSession>() {
			@Override
			public int compare(SabreSession ss1, SabreSession ss2) {
				return MiscUtil.compare(ss1.getCreateDate(), ss2.getCreateDate());
			}
		});
	%>
	<tr>
		<td><a href="#" onclick="toggle('<%=key%>')"><%= key %></a></td>
		<td><%= activeQty %></td>
		<td><%= onholdQty %></td>
		<td><%= totalQty %></td>
	</tr>
	<tr id="<%= key %>" style="display: none;">
		<td colspan="4">
			<ul><%for (SabreSession ss : sessions) {%>
				<li>
					<p><%= ss.getConversationId() %> (<%= ss.getStatus() %>)</p>
					<p><a href="#" onclick="toggle('<%=ss.getConversationId()%>')">trace</a></p>
					<table border="1" id="<%= ss.getConversationId() %>" style="display: none;">
						<tr>
							<th>date</th>
							<th>action</th>
							<th>data</th>
						</tr>
						<% for (TraceItem ti : ss.getTraces()) { %>
							<tr>
								<td><%= ti.date %></td>
								<td><%= ti.action %></td>
								<td><%= ti.data %></td>
							</tr>
						<% } %>
					</table>
				</li>
			<%}%></ul>
		</td>
	</tr>
	<% } %>
	</table>
</body>
</html>
