package com.gridnine.xtrip.server.support.model.questionnaire.scripts

import com.gridnine.xtrip.common.Environment
import com.gridnine.xtrip.common.model.asset.AssetsStorage
import com.gridnine.xtrip.common.model.assets.UserAccount
import com.gridnine.xtrip.common.model.booking.CommonProductIndex
import com.gridnine.xtrip.common.model.booking.ProductStatus
import com.gridnine.xtrip.common.model.booking.commission.ProductType
import com.gridnine.xtrip.common.model.dict.GdsName
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.questionnaire.RegisterAnswerSyncRequest
import com.gridnine.xtrip.common.parsers.model.AlfastrahExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.CCCExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.ExcessBagageExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.GabrielMaskExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.HotExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.HotelbookExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.InmobExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.IurExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.LiaisonExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.MCOExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.RenaissanceInsuranceExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.RetArchiveExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.RetExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.S7ExcelExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.SirenaXmlExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.SsodArchiveExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.SsodExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.TeletrainExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.UTSItineraryExchangeDocumentIndex
import com.gridnine.xtrip.common.railway.parsers.ExpressExchangeDocumentIndex
import com.gridnine.xtrip.common.railway.parsers.SPGDArchiveExchangeDocumentIndex
import com.gridnine.xtrip.common.railway.parsers.SPGDExchangeDocumentIndex
import com.gridnine.xtrip.common.railway.parsers.UFSExchangeDocumentIndex
import com.gridnine.xtrip.common.search.Projection
import com.gridnine.xtrip.common.search.ProjectionQuery
import com.gridnine.xtrip.common.search.ResultMode
import com.gridnine.xtrip.common.search.SearchCriterion
import com.gridnine.xtrip.common.search.SearchQuery
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.MiscUtil
import com.gridnine.xtrip.common.xml.XSUtil
import org.apache.commons.io.FileUtils

import java.text.SimpleDateFormat

if(Environment.getApplicationId().startsWith("vip-")){
    return;
}

//def answer = new RegisterAnswerSyncRequest();


class DateInterval{
    Date startDate;
    Date endDate;
    String title;
    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");

    DateInterval(String startDate, String endDate, String title){
        this.startDate = MiscUtil.clearTime(df.parse(startDate));
        this.endDate = MiscUtil.setDayEndTime(df.parse(endDate));
        this.title = title;
    }
}

def periods = []
periods << new DateInterval("2017-05-01", "2017-05-31","May2017")
periods << new DateInterval("2017-06-01", "2017-06-30","June2017")
periods << new DateInterval("2017-07-01", "2017-07-31","July2017")
periods << new DateInterval("2017-08-01", "2017-08-31","August2017")
periods << new DateInterval("2017-09-01", "2017-09-30","September2017")
periods << new DateInterval("2017-10-01", "2017-10-31","October2017")
periods << new DateInterval("2017-11-01", "2017-11-30","November2017")
periods << new DateInterval("2017-12-01", "2017-12-31","December2017")
periods << new DateInterval("2018-01-01", "2018-01-31","January2018")
periods << new DateInterval("2018-02-01", "2018-02-28","February2018")
periods << new DateInterval("2018-03-01", "2018-03-31","March2018")
periods << new DateInterval("2018-04-01", "2018-04-30","April2018")

StringBuilder sb = new StringBuilder();

SearchQuery query = new SearchQuery();
query.getCriteria().getCriterions().add(SearchCriterion.eq(UserAccount.Property.active.name(), true))
query.setResultMode(ResultMode.COUNT_ONLY);
int usersCount = AssetsStorage.get().search(UserAccount.class, query).getTotalCount();
sb.append("users: ${usersCount}\r\n")

sb.append("\r\nexchange files:\r\n")
periods.each { DateInterval period ->
    query = new SearchQuery();
    query.setResultMode(ResultMode.COUNT_ONLY);
    query.getCriteria().getCriterions().add(SearchCriterion.ge("created", period.startDate));
    query.getCriteria().getCriterions().add(SearchCriterion.le("created", period.endDate));
    def count = EntityStorage.get().search(IurExchangeDocumentIndex.class, query).getTotalCount();
    if (count > 0) {
        sb.append("\n${Environment.getApplicationId()};${period.title};IUR;${count}");
    }
    count = EntityStorage.get().search(RetExchangeDocumentIndex.class, query).getTotalCount();
    if (count > 0) {
        sb.append("\n${Environment.getApplicationId()};${period.title};RET;${count}");
    }
    count = EntityStorage.get().search(GabrielMaskExchangeDocumentIndex.class, query).getTotalCount();
    if (count > 0) {
        sb.append("\n${Environment.getApplicationId()};${period.title};Gabriel Mask;${count}");
    }
    count = EntityStorage.get().search(SirenaXmlExchangeDocumentIndex.class, query).getTotalCount();
    if (count > 0) {
        sb.append("\n${Environment.getApplicationId()};${period.title};Sirena XML;${count}")
    }
    count = EntityStorage.get().search(SsodExchangeDocumentIndex.class, query).getTotalCount();
    if (count > 0) {
        sb.append("\n${Environment.getApplicationId()};${period.title};SSOD;${count}");
    }
    count = EntityStorage.get().search(SPGDExchangeDocumentIndex.class, query).getTotalCount();
    if (count > 0) {
        sb.append("\n${Environment.getApplicationId()};${period.title};SPGD;${count}");
    }
    count = EntityStorage.get().search(UFSExchangeDocumentIndex.class, query).getTotalCount();
    if (count > 0) {
        sb.append("\n${Environment.getApplicationId()};${period.title};UFS;${count}");
    }
    count = EntityStorage.get().search(ExpressExchangeDocumentIndex.class, query).getTotalCount();
    if (count > 0) {
        sb.append("\n${Environment.getApplicationId()};${period.title};Express;${count}");
    }
    count = EntityStorage.get().search(HotelbookExchangeDocumentIndex.class, query).getTotalCount();
    if (count > 0) {
        sb.append("\n${Environment.getApplicationId()};${period.title};Hotelbook;${count}");
    }
    count = EntityStorage.get().search(S7ExcelExchangeDocumentIndex.class, query).getTotalCount();
    if (count > 0) {
        sb.append("\n${Environment.getApplicationId()};${period.title};S7 Excel;${count}");
    }
    count = EntityStorage.get().search(HotExchangeDocumentIndex.class, query).getTotalCount();
    if (count > 0) {
        sb.append("\n${Environment.getApplicationId()};${period.title};HOT;${count}");
    }
    try {
        count = EntityStorage.get().search(MCOExchangeDocumentIndex.class, query).getTotalCount();
        if (count > 0) {
            sb.append("\n${Environment.getApplicationId()};${period.title};MCO;${count}");
        }
    } catch (Exception e){
        //noops
    }
    count = EntityStorage.get().search(LiaisonExchangeDocumentIndex.class, query).getTotalCount();
    if (count > 0) {
        sb.append("\n${Environment.getApplicationId()};${period.title};Liason;${count}");
    }
    count = EntityStorage.get().search(SsodArchiveExchangeDocumentIndex.class, query).getTotalCount();
    if (count > 0) {
        sb.append("\n${Environment.getApplicationId()};${period.title};SSOD Archive;${count}");
    }
    count = EntityStorage.get().search(RetArchiveExchangeDocumentIndex.class, query).getTotalCount();
    if (count > 0) {
        sb.append("\n${Environment.getApplicationId()};${period.title};RET Archive;${count}");
    }
    count = EntityStorage.get().search(RenaissanceInsuranceExchangeDocumentIndex.class, query).getTotalCount();
    if (count > 0) {
        sb.append("\n${Environment.getApplicationId()};${period.title};Ренессанс;${count}");
    }
    count = EntityStorage.get().search(CCCExchangeDocumentIndex.class, query).getTotalCount();
    if (count > 0) {
        sb.append("\n${Environment.getApplicationId()};${period.title};Файлы сравнения ЕЦВ;${count}");
    }
    count = EntityStorage.get().search(UTSItineraryExchangeDocumentIndex.class, query).getTotalCount();
    if (count > 0) {
        sb.append("\n${Environment.getApplicationId()};${period.title};UTS itinerary;${count}");
    }
    count = EntityStorage.get().search(SPGDArchiveExchangeDocumentIndex.class, query).getTotalCount();
    if (count > 0) {
        sb.append("\n${Environment.getApplicationId()};${period.title};SPGD Archive;${count}");
    }
    count = EntityStorage.get().search(AlfastrahExchangeDocumentIndex.class, query).getTotalCount();
    if (count > 0) {
        sb.append("\n${Environment.getApplicationId()};${period.title};Альфастрахование;${count}");
    }
    count = EntityStorage.get().search(ExcessBagageExchangeDocumentIndex.class, query).getTotalCount();
    if (count > 0) {
        sb.append("\n${Environment.getApplicationId()};${period.title};Багажки;${count}");
    }
    count = EntityStorage.get().search(TeletrainExchangeDocumentIndex.class, query).getTotalCount();
    if (count > 0) {
        sb.append("\n${Environment.getApplicationId()};${period.title};Teletrain;${count}");
    }
    count = EntityStorage.get().search(InmobExchangeDocumentIndex.class, query).getTotalCount();
    if (count > 0) {
        sb.append("\n${Environment.getApplicationId()};${period.title};Инновационная мобильность;${count}");
    }
}
sb.append("\r\n\r\nProducts:\r\n")
periods.each { DateInterval period ->
    ProjectionQuery pq = new ProjectionQuery();
    pq.getCriteria().getCriterions().add(SearchCriterion.ge(CommonProductIndex.Property.issueDate.name(), period.startDate));
    pq.getCriteria().getCriterions().add(SearchCriterion.le(CommonProductIndex.Property.issueDate.name(), period.endDate));
    pq.getCriteria().getCriterions().add(SearchCriterion.ne(CommonProductIndex.Property.status.name(), ProductStatus.EXCHANGE));
    pq.projections.add(Projection.count(CommonProductIndex.Property.productType.name(),"_count"));
    pq.projections.add(Projection.group(CommonProductIndex.Property.productType.name(), "_type"))
    pq.projections.add(Projection.group(CommonProductIndex.Property.gdsName.name(), "_gds"))
    pq.projections.add(Projection.group(CommonProductIndex.Property.status.name(), "_status"))
    pq.criteria.orders.put(CommonProductIndex.Property.productType.name(), SortOrder.ASC);
    pq.criteria.orders.put(CommonProductIndex.Property.gdsName.name(), SortOrder.ASC);
    pq.criteria.orders.put(CommonProductIndex.Property.status.name(), SortOrder.ASC);
    def data = EntityStorage.get().search(CommonProductIndex.class, pq).getData();
    data.each {Map<String, Object> entry ->
        int count = entry.get("_count")
        ProductType type = entry.get("_type");
        GdsName gds = entry.get("_gds")
        ProductStatus status = entry.get("_status")
        sb.append("\n${Environment.getApplicationId()};${period.title};${type};${gds};${status};${count}");
    }



}
answer.textData = sb.toString()

//String serialized = XSUtil.toString(answer)
//FileUtils.write(new File(Environment.tempFolder, "answer.txt"), serialized)
