package com.gridnine.xtrip.server.support.model.questionnaire.scripts

import com.gridnine.xtrip.common.Environment
import com.gridnine.xtrip.common.model.asset.AssetsStorage
import com.gridnine.xtrip.common.model.assets.UserAccount
import com.gridnine.xtrip.common.model.booking.CommonProductIndex
import com.gridnine.xtrip.common.model.booking.ProductIndex
import com.gridnine.xtrip.common.model.booking.ProductStatus
import com.gridnine.xtrip.common.model.booking.air.Product
import com.gridnine.xtrip.common.model.booking.commission.ProductType
import com.gridnine.xtrip.common.model.dict.GdsName
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.helpers.BookingHelper
import com.gridnine.xtrip.common.model.questionnaire.RegisterAnswerSyncRequest
import com.gridnine.xtrip.common.parsers.model.AlfastrahExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.CCCExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.ExcessBagageExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.GabrielMaskExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.HotExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.HotelbookExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.InmobExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.IurExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.LiaisonExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.MCOExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.RenaissanceInsuranceExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.RetArchiveExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.RetExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.S7ExcelExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.SirenaXmlExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.SsodArchiveExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.SsodExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.TeletrainExchangeDocumentIndex
import com.gridnine.xtrip.common.parsers.model.UTSItineraryExchangeDocumentIndex
import com.gridnine.xtrip.common.railway.parsers.ExpressExchangeDocumentIndex
import com.gridnine.xtrip.common.railway.parsers.SPGDArchiveExchangeDocumentIndex
import com.gridnine.xtrip.common.railway.parsers.SPGDExchangeDocumentIndex
import com.gridnine.xtrip.common.railway.parsers.UFSExchangeDocumentIndex
import com.gridnine.xtrip.common.search.Projection
import com.gridnine.xtrip.common.search.ProjectionQuery
import com.gridnine.xtrip.common.search.ResultMode
import com.gridnine.xtrip.common.search.SearchCriterion
import com.gridnine.xtrip.common.search.SearchQuery
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.MiscUtil
import com.gridnine.xtrip.common.xml.XSUtil
import org.apache.commons.io.FileUtils
import org.apache.commons.logging.Log
import org.apache.commons.logging.LogFactory

import java.text.SimpleDateFormat

if (Environment.getApplicationId().startsWith("vip-")) {
    return;
}
Log log = LogFactory.getLog("groovy-script");
def answer = new RegisterAnswerSyncRequest();


class DateInterval2 {
    Date startDate;
    Date endDate;
    String title;
    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");

    DateInterval2(String startDate, String endDate, String title) {
        this.startDate = MiscUtil.clearTime(df.parse(startDate));
        this.endDate = MiscUtil.setDayEndTime(df.parse(endDate));
        this.title = title;
    }
}

class Key2 {
    ProductStatus status;
    GdsName gds;


    Key2(ProductStatus status, GdsName gds) {
        this.status = status
        this.gds = gds
    }

    @Override
    boolean equals(Object obj) {
        Key2 key2 = obj;
        return key2.status == status && key2.gds == gds
    }

    @Override
    int hashCode() {
        return "${status}-${gds}".hashCode()
    }
}

def periods = []

periods << new DateInterval2("2018-01-01", "2018-01-31", "0118_January")
periods << new DateInterval2("2018-02-01", "2018-02-28", "0218_February")
periods << new DateInterval2("2018-03-01", "2018-03-31", "0318_March")
periods << new DateInterval2("2018-04-01", "2018-04-30", "0418_April")
periods << new DateInterval2("2018-05-01", "2018-05-31", "0518_May")
periods << new DateInterval2("2018-06-01", "2018-06-30", "0618_June")
periods << new DateInterval2("2018-06-01", "2018-07-31", "0718_July")
periods << new DateInterval2("2018-08-01", "2018-08-31", "0818_August")



StringBuilder sb = new StringBuilder();

int periodsCount = periods.size()
int index = 0
periods.each { DateInterval2 period ->
    Map<Key2, Integer> result = [:]
    index++
    progress("processing ${index} from ${periodsCount}".toString(), (int) (100d * (index - 1) / periodsCount))
    SearchQuery pq = new SearchQuery();
    pq.getCriteria().getCriterions().add(SearchCriterion.ge(ProductIndex.Property.issueDate.name(), period.startDate));
    pq.getCriteria().getCriterions().add(SearchCriterion.le(ProductIndex.Property.issueDate.name(), period.endDate));
    pq.getCriteria().getCriterions().add(SearchCriterion.ne(ProductIndex.Property.status.name(), ProductStatus.EXCHANGE));
    pq.preferredProperties.add(ProductIndex.Property.status.name())
    def data = EntityStorage.get().search(ProductIndex.class, pq).getData();
    data.each { idx ->
        try {
            def ctr = EntityStorage.get().resolve(idx.source)
            if (ctr) {
                Product prod = BookingHelper.findProduct(ctr.entity, idx.navigationKey)
                if (prod && prod.pcc != null && prod.pcc.startsWith("XXX")) {
                    log.debug("found product ${prod.systemNumber} with suspicios pcc ${prod.pcc} ")
                    Key2 key2 = new Key2(prod.status, prod.reservation.gdsName);
                    Integer number = result[key2]
                    result[key2] = number == null ? Integer.valueOf(1) : Integer.valueOf(number.intValue() + 1)
                }
            }
        } catch (Exception e) {
            //
        }
    }
    for (def entry : result.entrySet()) {
        def key = entry.key
        sb.append("\r\n${period.title};${key.gds};${key.status};${entry.value}")
    }


}
answer.textData = sb.toString()

String serialized = XSUtil.toString(answer)
FileUtils.write(new File(Environment.tempFolder, "answer.txt"), serialized)
