package com.gridnine.xtrip.server.support.model.questionnaire.scripts

import com.gridnine.xtrip.common.Environment
import com.gridnine.xtrip.common.l10n.model.LocaleHelper
import com.gridnine.xtrip.common.model.booking.ProductIndex
import com.gridnine.xtrip.common.model.booking.ProductStatus
import com.gridnine.xtrip.common.model.booking.air.Product
import com.gridnine.xtrip.common.model.booking.statistics.ProductBillingDataChangeEntry
import com.gridnine.xtrip.common.model.dict.Airline
import com.gridnine.xtrip.common.model.dict.DictionaryCache
import com.gridnine.xtrip.common.model.dict.GdsName
import com.gridnine.xtrip.common.model.dict.ProductCategory
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper
import com.gridnine.xtrip.common.search.SearchCriterion
import com.gridnine.xtrip.common.search.SearchQuery
import com.gridnine.xtrip.common.search.SortOrder
import com.gridnine.xtrip.common.util.MiscUtil

import java.text.SimpleDateFormat

class DateIntervalCps {
    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd")
    Date startDate
    Date endDate
    String title

    DateIntervalCps(String startDate, String endDate, String title) {
        this.startDate = MiscUtil.clearTime(dateFormat.parse(startDate))
        this.endDate = MiscUtil.setDayEndTime(dateFormat.parse(endDate))
        this.title = title
    }
}

class ProductBatchData {
    String source
    String period
    String carrier
    String productType
    String status
    int count

    ProductBatchData(String source, String period, String carrier, String productType, String status) {
        this.source = source
        this.period = period
        this.carrier = carrier
        this.productType = productType
        this.status = status
    }

    @Override
    boolean equals(final o) {
        if (this.is(o)) return true
        if (getClass() != o.class) return false

        ProductBatchData that = (ProductBatchData) o
        if (carrier != that.carrier || period != that.period || source != that.source
                || productType != that.productType || status != that.status) {
            return false
        }
        return true
    }

    @Override
    int hashCode() {
        int result = 0
        result = 31 * result + ((source != null) ? source.hashCode() : 0)
        result = 31 * result + ((carrier != null) ? carrier.hashCode() : 0)
        result = 31 * result + ((period != null) ? period.hashCode() : 0)
        result = 31 * result + ((productType != null) ? productType.hashCode() : 0)
        result = 31 * result + ((status != null) ? status.hashCode() : 0)
        return result
    }
}

def periods = new ArrayList<DateIntervalCps>()

periods << new DateIntervalCps("2022-01-01", "2022-01-31", "2022_01_Jan")
periods << new DateIntervalCps("2022-02-01", "2022-02-28", "2022_02_Feb")
periods << new DateIntervalCps("2022-03-01", "2022-03-31", "2022_03_Mar")
periods << new DateIntervalCps("2022-04-01", "2022-04-30", "2022_04_Apr")
periods << new DateIntervalCps("2022-05-01", "2022-05-31", "2022_05_May")
periods << new DateIntervalCps("2022-06-01", "2022-06-30", "2022_06_Jun")

def builder = new StringBuilder()
periods.each { DateIntervalCps period ->
    SearchQuery pq = new SearchQuery()
    pq.getCriteria().getCriterions().addAll([
            SearchCriterion.ge(ProductIndex.Property.issueDate.name(), period.startDate),
            SearchCriterion.le(ProductIndex.Property.issueDate.name(), period.endDate),
            SearchCriterion.in(ProductIndex.Property.status.name(), ProductStatus.SELL, ProductStatus.BOOKING)
    ])
    pq.criteria.orders.put(ProductIndex.Property.gdsName.name(), SortOrder.ASC)
    pq.criteria.orders.put(ProductIndex.Property.carrier.name(), SortOrder.ASC)
    List<ProductBatchData> productDatas = new ArrayList<>()

    def data = EntityStorage.get().search(ProductIndex.class, pq).getData()
    data.groupBy { it.source }.each {
        def bookingFileCtr = EntityStorageHelper.resolve(it.key)
        if (bookingFileCtr) {
            it.value.each { ProductIndex prodIndex ->
                GdsName gds = prodIndex.getGdsName()
                def carrier = prodIndex.getCarrier()
                def category = prodIndex.getProductCategory()
                def mcoCategory = prodIndex.getMcoCategory()
                def status = prodIndex.getStatus()
                if (gds != null && carrier != null && status != null && category != null
                        && (category == ProductCategory.AIR || mcoCategory != null)) {
                    String gdsName = gds.toString(LocaleHelper.EN_LOCALE)
                    Airline airline = DictionaryCache.get().resolveReference(carrier)
                    if (airline != null && airline.codeVariants.values().contains("SU")) {
                        def product = (Product) bookingFileCtr.entity.reservations.collectMany { it.products }
                                .find { it.uid == prodIndex.navigationKey }
                        if (product) {
                            removeDuplicateEntries(product.getBillingDataChangeEntries())
                            product.getBillingDataChangeEntries().each {
                                def prodCategory = (category == ProductCategory.AIR) ?
                                        category.toString(LocaleHelper.RU_LOCALE) : mcoCategory.toString(LocaleHelper.RU_LOCALE)
                                def productData = new ProductBatchData(gdsName, period.title, "SU",
                                        prodCategory, status.toString())
                                if (productDatas.contains(productData)) {
                                    def foundProductData = productDatas.find {
                                        it == productData
                                    }
                                    foundProductData.setCount(foundProductData.getCount() + 1)
                                } else {
                                    productData.setCount(1)
                                    productDatas.add(productData)
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    productDatas.each {
        builder.append("\n${Environment.getApplicationId()};${it.getPeriod()};${it.getSource()};${it.getCarrier()};" +
                "${it.getProductType()};${it.getStatus()};${it.getCount()}")
    }
}

answer.booleanData = !(builder.length() == 0)
answer.textData = builder.toString()

static void removeDuplicateEntries(List<ProductBillingDataChangeEntry> prodEntries) {
    List<ProductBillingDataChangeEntry> entries = new ArrayList<>(prodEntries)
    boolean hasDeletedEntries = false
    ProductStatus lastStatus = null
    for (ProductBillingDataChangeEntry entry : prodEntries) {
        if (lastStatus == null) {
            lastStatus = entry.getStatus()
            continue
        }
        if (entry.getStatus() == lastStatus) {
            entries.remove(entry)
            hasDeletedEntries = true
            continue
        }
        lastStatus = entry.getStatus()
    }
    if (hasDeletedEntries) {
        prodEntries.clear()
        prodEntries.addAll(entries)
    }
}
