package com.gridnine.xtrip.server.support.model.questionnaire.scripts

import com.gridnine.xtrip.common.Environment
import com.gridnine.xtrip.common.gds.sabre.rules.SabreActions
import com.gridnine.xtrip.common.midoffice.model.ComplementBookingSettings
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex
import com.gridnine.xtrip.common.rules.RuleSettings
import com.gridnine.xtrip.common.search.SearchQuery

def builder = new StringBuilder()
for (BasicSystemSettingsIndex settingsIdx : EntityStorage.get().search(
        BasicSystemSettingsIndex.class, new SearchQuery()).getData()) {
    def settingsCtr = EntityStorage.get().resolve(settingsIdx.source)
    if (!(settingsCtr.getEntity() instanceof ComplementBookingSettings)) {
        continue
    }
    ComplementBookingSettings complementBookingSettings = (ComplementBookingSettings) settingsCtr.getEntity()
    for (RuleSettings rule : complementBookingSettings.getRuleSet().getRules()) {
        if (rule.getResults().any { result ->
            result.getAction() == SabreActions.SABRE_CO2_EMISSIONS_COMPLEMENT_BOOKING
        }) {
            builder.append("\n${Environment.getApplicationId()}; ${complementBookingSettings.getName()}; ")
            rule.getRestrictions().forEach({ restriction ->
                builder.append("${restriction.getProperty()} ${restriction.getCondition()} ${restriction.getValue()}; ")
            })
        }
    }
}

answer.booleanData = !(builder.length() == 0)
answer.textData = builder.toString()
