package com.gridnine.xtrip.server.ibecorp.scripts

import com.gridnine.xtrip.common.model.EntityContainer
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.system.BillingTransaction
import com.gridnine.xtrip.common.model.system.BillingTransactionIndex
import com.gridnine.xtrip.common.search.SearchQuery
import com.gridnine.xtrip.common.search.SortOrder
import org.apache.commons.logging.Log
import org.apache.commons.logging.LogFactory

Log log = LogFactory.getLog("billing_transaction_resave_task")

int limit = 5000;
int offset = 0;
log.debug("start task");

while (true) {
    try {
        SearchQuery query = new SearchQuery();
        query.setLimit(limit);
        query.setOffset(offset);
        log.debug(String.format("offset = %d", offset));
        query.getPreferredProperties().contains("containerUid");
        query.getCriteria().getOrders().put("containerUid",
                SortOrder.ASC);
        List<BillingTransactionIndex> data = EntityStorage.get()
                .search(BillingTransactionIndex.class, query).getData();
        log.debug(String.format("found %d entries", data.size()));
        if (data.size() == 0) {
            break;
        }
        for (BillingTransactionIndex index : data) {
            try {
                EntityContainer<BillingTransaction> billingTransactionCtr =
                        EntityStorage.get().load(BillingTransaction.class,
                                index.getSource().getUid());
                billingTransactionCtr.getVersionInfo()
                        .setVersionNotes("Billing Transaction resave task");
                EntityStorage.get().save(billingTransactionCtr, true);
            } catch (Throwable throwable) {
                String errorMsg = String.format(
                        "error while while processing transaction with containerUid = '%s'",
                        index.getSource().getUid())
                error(errorMsg)
                log.error(errorMsg, throwable);
                break;
            }

        }
        offset += limit;
    } catch (Throwable throwable) {
        error("error while query BillingTransactionIndex data")
        log.error("error while query BillingTransactionIndex data",
                throwable);
        break;
    }
}
log.debug("finish task");