import com.gridnine.xtrip.common.ibecorp.rules.IbecorpProperties
import com.gridnine.xtrip.common.model.EntityReference
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.profile.ContractIndex
import com.gridnine.xtrip.common.model.profile.ModelContractIndex
import com.gridnine.xtrip.common.model.profile.TripartiteContractIndex
import com.gridnine.xtrip.common.rules.RuleSet
import com.gridnine.xtrip.common.rules.RuleSettings
import com.gridnine.xtrip.common.search.SearchQuery

def static process(EntityReference ref, RuleSet rs, StringBuilder sb) {
    if (rs == null) return
    if (rs.rules == null) return
    rs.rules.eachWithIndex { RuleSettings entry, int i ->
        if (entry.restrictions.find {it.property == IbecorpProperties.TRIPARTITE_AGREEMENT } ) {
            sb.append("uid=${ref.uid}, class=${ref.type.name}, index=${i}; ")
        }
    }
}

def es = EntityStorage.get()
def sb = new StringBuilder()
def query = new SearchQuery()
query.preferredProperties.add('uid')
es.search(ContractIndex.class, query).data.each {
    process(it.source, es.resolve(it.source).entity.ruleSet, sb)
}
es.search(ModelContractIndex.class, query).data.each {
    process(it.source, es.resolve(it.source).entity.ruleSet, sb)
}
es.search(TripartiteContractIndex.class, query).data.each {
    process(it.source, es.resolve(it.source).entity.ruleSet, sb)
}
answer.booleanData = sb.length() > 0
answer.textData = sb.toString()
