import com.gridnine.xtrip.common.l10n.model.LocaleManager
import com.gridnine.xtrip.common.rules.RulesEnvironment
import org.apache.commons.lang.StringEscapeUtils

def re = RulesEnvironment.get()
def rps = [:]
def ras = [:]
def loc = LocaleManager.get().getCurrentLocale()

try {

    LocaleManager.get().setCurrentLocale(Locale.ENGLISH)

    re.filteringCategories.each { fc ->
        re.getProperties(fc).each { rp ->
            if (!rps.containsKey(rp)) {
                rps[rp] = []
            }
            rps[rp].add(fc)
        }
        re.getActions(fc).each { ra ->
            if (!ras.containsKey(ra)) {
                ras[ra] = []
            }
            ras[ra].add(fc)
        }
    }

    def fcs = re.filteringCategories.sort { it.displayName }

    def sbp = new StringBuilder()
    sbp.append('Property,Condition(s),')
    sbp.append(fcs.collect {  StringEscapeUtils.escapeCsv(it.displayName) }.join(','))
    sbp.append('<br>')
    rps.sort { it.key.displayName }.each { rp ->
        sbp.append(StringEscapeUtils.escapeCsv(rp.key.displayName))
        sbp.append(',')
        sbp.append(StringEscapeUtils.escapeCsv(re.getConditions(rp.key).collect { it.displayName }.sort().join(', ')))
        sbp.append(',')
        fcs.each {
            if (rp.value.contains(it)) {
                sbp.append('+')
            }
            sbp.append(',')
        }
        sbp.append('<br>')
    }
    //message(sbp.toString())

    def sap = new StringBuilder()
    sap.append('Action,')
    sap.append(fcs.collect {  StringEscapeUtils.escapeCsv(it.displayName) }.join(','))
    sap.append('<br>')
    ras.sort { it.key.displayName }.each { ra ->
        sap.append(StringEscapeUtils.escapeCsv(ra.key.displayName))
        sap.append(',')
        fcs.each {
            if (ra.value.contains(it)) {
                sap.append('+')
            }
            sap.append(',')
        }
        sap.append('<br>')
    }
    message(sap.toString())

} finally {
    LocaleManager.get().setCurrentLocale(loc)
}
