import com.gridnine.xtrip.common.l10n.model.L10nString
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper
import com.gridnine.xtrip.common.l10n.model.LocaleHelper
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.profile.Organization
import com.gridnine.xtrip.common.model.profile.OrganizationIndex
import com.gridnine.xtrip.common.search.SearchQuery

def file = new File('/tmp/IBECORP-6514.csv')
file.write('"Короткое название (RU)","Короткое название (EN)","Полное название (RU)","Полное название (EN)","Код","Внутренний UID"\n')

def query = new SearchQuery()
query.preferredProperties.add('uid')
EntityStorage.get().search(OrganizationIndex.class, query).data.each {
    Organization org = (Organization) EntityStorage.get().resolve(it.source).entity
    file.append("\"${s(org.getShortName(), LocaleHelper.RU_LOCALE)}\"," +
            "\"${s(org.getShortName(), LocaleHelper.EN_LOCALE)}\"," +
            "\"${s(org.getFullName(), LocaleHelper.RU_LOCALE)}\"," +
            "\"${s(org.getFullName(), LocaleHelper.EN_LOCALE)}\"," +
            "\"${s(org.getCode())}\"," +
            "\"${s(org.getUid())}\"\n")
}

String s(String value) {
    return value ? value.replaceAll('"', '""') : ''
}

String s(L10nString value, Locale loc) {
    return s(L10nStringHelper.getValue(value, loc))
}
