import com.gridnine.xtrip.common.model.EntityReference
import com.gridnine.xtrip.common.model.booking.ProductIndex
import com.gridnine.xtrip.common.model.booking.air.Product
import com.gridnine.xtrip.common.model.dict.ClassOfService
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.profile.Organization
import com.gridnine.xtrip.common.search.SearchCriterion
import com.gridnine.xtrip.common.search.SearchQuery

def u6Data = [
        'C': ClassOfService.BUSINESS,
        'F': ClassOfService.BUSINESS,
        'D': ClassOfService.BUSINESS,
        'Z': ClassOfService.BUSINESS,
        'I': ClassOfService.BUSINESS,
        'Y': ClassOfService.ECONOMY,
        'T': ClassOfService.ECONOMY,
        'U': ClassOfService.ECONOMY,
        'G': ClassOfService.ECONOMY,
        'R': ClassOfService.ECONOMY,
        'S': ClassOfService.ECONOMY,
        'Q': ClassOfService.ECONOMY,
        'L': ClassOfService.ECONOMY,
        'B': ClassOfService.ECONOMY,
        'V': ClassOfService.ECONOMY,
        'H': ClassOfService.ECONOMY,
        'M': ClassOfService.ECONOMY,
        'K': ClassOfService.ECONOMY,
        'X': ClassOfService.ECONOMY,
        'P': ClassOfService.ECONOMY,
        'N': ClassOfService.ECONOMY,
        'E': ClassOfService.ECONOMY,
        'A': ClassOfService.ECONOMY,
        'W': ClassOfService.ECONOMY,
        'O': ClassOfService.ECONOMY
]

def query = new SearchQuery()
//query.criteria.criterions.add(SearchCriterion.or(SearchCriterion.eq(ProductIndex.Property.carrier.name(), new AirlineReference('U6')), SearchCriterion.eq(ProductIndex.Property.carrier.name(), new AirlineReference('DP'))))
query.criteria.criterions.add(SearchCriterion.eq(ProductIndex.Property.client.name(), new EntityReference('eb68b2c7-5132-48c3-95f3-f77f6a157ff6', Organization.class, null)))
query.preferredProperties.add('uid')
def idxs = EntityStorage.get().search(ProductIndex.class, query).data.collect { it.source }.unique()
message("${idxs.size()} bookings to process")
idxs.each {
    def ctr = EntityStorage.get().resolve(it)
    boolean needsSave = false
    ctr.entity.reservations.each {
        it.products.findAll { it instanceof Product }.collect { (Product) it }.each {
            it.segmentTariffs.each {
                it.segments.each {
                    def airline = it.airline?.code
                    def requiredClassOfService = airline == 'U6' ? u6Data[it.classOfSvcCode] : (airline == 'ДР' ? ClassOfService.ECONOMY : null)
                    if (requiredClassOfService != null && requiredClassOfService != it.serviceClass) {
                        it.serviceClass = requiredClassOfService
                        needsSave = true
                    }
                }
            }
        }
    }
    if (needsSave) {
        message("modified booking ${ctr.entity.number}")
        ctr.versionInfo.dataSource = 'TUIBT-2966'
        EntityStorage.get().save(ctr, true)
    }
}

