package com.gridnine.xtrip.server.ibecorp.tasks.groovy

import com.gridnine.xtrip.common.model.EntityReference
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite
import com.gridnine.xtrip.common.model.profile.Organization
import com.gridnine.xtrip.common.model.profile.OrganizationIndex
import com.gridnine.xtrip.common.model.profile.RulesHolder
import com.gridnine.xtrip.common.model.profile.RulesHolderIndex
import com.gridnine.xtrip.common.rules.RuleSettings
import com.gridnine.xtrip.common.search.SearchCriterion
import com.gridnine.xtrip.common.search.SearchQuery

StringBuilder builder = new StringBuilder()
boolean result = false;

if (findRulesHolders(builder)){
    result = true
}
if (findOrganizationWithRuleList(builder)){
    result = true
}

answer.booleanData = result
answer.textData = builder.toString()

//message String.valueOf(result)
//builder.toString().split("\n").each { message it}


boolean findRulesHolders(StringBuilder builder){
    builder.append("\nПоиск правил с условием по агентству\n")
    boolean result = false;
    SearchQuery sq = new SearchQuery()
    List<RulesHolderIndex> rulesHolderIndexes = EntityStorage.get().search(RulesHolderIndex.class, sq).getData()
    builder.append("всего ${rulesHolderIndexes.size()} правил сайта\n")

    rulesHolderIndexes.each {

        RulesHolder rulesHolder = EntityStorage.get().resolve(it.source)?.getEntity()
        if (existsAgencyCondition(rulesHolder, builder)){
            result = true;
        }

    }
    return result;
}

static boolean existsAgencyCondition(RulesHolder rulesHolder, StringBuilder builder){
    if (rulesHolder?.ruleSet == null) {
        return false;
    }
    List<RuleSettings> all = rulesHolder.ruleSet.rules.findAll { rs -> rs.restrictions.find { "AGENCY_CODE".equals(it.property?.id) } != null }
    builder.append("\nВ ${rulesHolder.name} найдено ${all.size()} правил: \n")
    all.groupBy {it.filteringCategory}.each {
        builder.append("${it.key?.displayName} :\n")
        it.value.each { rs ->
            builder.append("${rs.getRestrictionsInfoNoHtml()} \n")
        }
    }
    return all.size()>0
}

static boolean findOrganizationWithRuleList(StringBuilder builder){
    builder.append("\nПоиск организаций с несколькими правилами сайта\n")
    boolean result = false;
    SearchQuery sq = new SearchQuery()
    sq.criteria.criterions.add(SearchCriterion.or(
            SearchCriterion.isNotEmpty(OrganizationIndex.Property.b2bRulesUids.name()),
            SearchCriterion.isNotEmpty(OrganizationIndex.Property.b2cRulesUids.name())
    ))
    sq.preferredProperties.add(OrganizationIndex.Property.code.name())
    List<OrganizationIndex> orgIndexes = EntityStorage.get().search(OrganizationIndex.class, sq).getData()
    builder.append("найдено ${orgIndexes.size()} организаций с хотя бы с одной ссылкой на правила сайта \n")

    Map<EntityReference<SMSite>, Map<String, SiteRulesHolders>> siteRulesMap = new HashMap<>()

    orgIndexes.each {

        Organization org = EntityStorage.get().resolve(it.source)?.getEntity()
        String orgName = "${org.shortName} (${org.code})"
        if (org.getB2bRules().size()>1){
            builder.append("У организации ${orgName} установлено ${org.getB2bRules().size()} правил сайта B2B\n")
            result = true;
        }
        if (org.getB2cRules().size()>1){
            builder.append("У организации ${orgName} установлено ${org.getB2cRules().size()} правил сайта B2C\n")
            result = true;
        }
        if (checkSiteRules(siteRulesMap, org.getB2bSite(), org.getB2bRules(), orgName, builder, true)){
            result = true;
        }
        if (checkSiteRules(siteRulesMap, org.getB2cSite(), org.getB2cRules(), orgName, builder, false)){
            result = true;
        }
    }

    //builder.append("${siteRulesMap} \n")

    siteRulesMap.each {
        EntityReference<SMSite> site = it.key
        Map<String, SiteRulesHolders> siteRulesHoldersMap = it.value
        if (siteRulesHoldersMap.size()>1){
            builder.append("Для сайта ${site.caption} выставлены разные правила в организациях: \n")
            siteRulesHoldersMap.each {srm ->
                SiteRulesHolders siteRulesHolders = srm.value
                builder.append("  Правила ${siteRulesHolders.rulesHolders}\n")
                if (!siteRulesHolders.b2bOrganizations.isEmpty()){
                    builder.append("    у организациий b2b ${siteRulesHolders.b2bOrganizations}\n")
                }
                if (!siteRulesHolders.b2cOrganizations.isEmpty()){
                    builder.append("    у организациий b2c ${siteRulesHolders.b2cOrganizations}\n")
                }
            }
            result = true;
        }
    }
    return result;
}

static boolean checkSiteRules(Map<EntityReference<SMSite>, Map<String, SiteRulesHolders>> siteRulesMap,
                           EntityReference<SMSite> site, List<EntityReference<RulesHolder>> rulesHolders,
                           String orgName, StringBuilder builder, boolean isB2B){
    if (site==null && rulesHolders.isEmpty()){
        return false
    }
    if (site==null && !rulesHolders.isEmpty()){
        builder.append("У организации ${orgName} есть правила сайта, но нет сайта\n")
        return true
    }
//    if (site!=null && rulesHolders.isEmpty()){
//        builder.append("У организации ${orgName} есть сайт, но нет правил сайта\n")
//        return true
//    }
    Map<String, SiteRulesHolders> siteRulesHoldersMap = siteRulesMap.get(site)
    if (siteRulesHoldersMap == null){
        siteRulesHoldersMap = new HashMap<String, SiteRulesHolders>();
        siteRulesMap.put(site, siteRulesHoldersMap)
    }
    String rulesKey = buildKey(rulesHolders)
    SiteRulesHolders siteRulesHolders = siteRulesHoldersMap.get(rulesKey)
    if (siteRulesHolders==null){
        siteRulesHolders = new SiteRulesHolders()
        siteRulesHoldersMap.put(rulesKey, siteRulesHolders)
        siteRulesHolders.rulesHolders.addAll(rulesHolders)
    }
    if (isB2B){
        siteRulesHolders.b2bOrganizations.add(orgName)
    } else {
        siteRulesHolders.b2cOrganizations.add(orgName)
    }
    return false
}

static String buildKey(List<EntityReference<RulesHolder>> rules){
    return rules.collect {it.uid} .sort().join(":")
}

class SiteRulesHolders {

    List<EntityReference<RulesHolder>> rulesHolders = new ArrayList<>()
    List<String> b2bOrganizations = new ArrayList<>()
    List<String> b2cOrganizations = new ArrayList<>()


    @Override
    String toString() {
        return "SiteRulesHolders{" +
                "rulesHolders=" + rulesHolders +
                ", b2bOrganizations=" + b2bOrganizations +
                ", b2cOrganizations=" + b2cOrganizations +
                '}';
    }
}