package com.gridnine.xtrip.server.ibecorp.tasks.groovy

import com.gridnine.xtrip.common.model.EntityContainer
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper
import com.gridnine.xtrip.common.model.profile.ModelContract
import com.gridnine.xtrip.common.model.profile.ModelContractIndex
import com.gridnine.xtrip.common.model.rules.standard.CommonProductProperties
import com.gridnine.xtrip.common.model.rules.standard.ContractsFilteringCategories
import com.gridnine.xtrip.common.model.rules.standard.GeneralProductActions
import com.gridnine.xtrip.common.rules.RuleSettings
import com.gridnine.xtrip.common.search.SearchQuery

ArrayList<GeneralProductActions> fees = Arrays.asList(
        GeneralProductActions.GENERAL_COMMISSION, GeneralProductActions.GENERAL_FEE,
        GeneralProductActions.GENERAL_PAYMENT_FEE, GeneralProductActions.GENERAL_DISCOUNT)

StringBuilder builder = new StringBuilder()

int total = 0

List<ModelContractIndex> contractIndexList = EntityStorage.get().search(ModelContractIndex.class, new SearchQuery()).getData()

builder.append("Найдено $contractIndexList.size правил договоров\nСписок правил договора:")

for (ModelContractIndex index : contractIndexList) {
    EntityContainer<ModelContract> modelContract = EntityStorage.get().resolve(index.getSource())
    if (EntityStorageHelper.isEmpty(modelContract)) {
        continue
    }

    if (modelContract.getEntity().getRuleSet() == null) {
        continue
    }

    for (RuleSettings rule : modelContract.getEntity().getRuleSet().getRules()) {
        if (rule.getRestrictions().isEmpty()
                || rule.getFilteringCategory() != ContractsFilteringCategories.MODEL_CONTRACT) {
            continue
        }

        boolean hasProductStatus = rule.getRestrictions()
                .stream()
                .anyMatch({ r -> r.getProperty() == CommonProductProperties.PRODUCT_STATUS })

        if (!hasProductStatus) {
            continue
        }

        boolean hasFees = rule.getResults()
                .stream()
                .anyMatch({ r -> fees.contains(r.getAction()) })
        if (!hasFees) {
            continue
        }
        builder.append("\n $index.name")
        total++
    }
}
answer.booleanData = !(builder.length() == 0)
builder.append("\n $total")
answer.textData = builder.toString()
