package com.gridnine.xtrip.server.ibecorp.tasks.groovy

import com.gridnine.xtrip.common.model.booking.railway.RailwayProductIndex
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.profile.ContractIndex
import com.gridnine.xtrip.common.model.profile.OrganizationIndex
import com.gridnine.xtrip.common.search.ResultMode
import com.gridnine.xtrip.common.search.SearchCriterion
import com.gridnine.xtrip.common.search.SearchQuery

def es = EntityStorage.get()

SearchQuery query = new SearchQuery()
query.preferredProperties.add('containerUid')
query.preferredProperties.add(OrganizationIndex.Property.code.name())
query.criteria.criterions.add(
        SearchCriterion.or(
                SearchCriterion.in(OrganizationIndex.Property.code.name(), "РЖД", "RZD"),
                SearchCriterion.in("containerUid", "rzd_container", "organization-blankowner-RZD-9et6h2"),
        )
)

List<String> answerLines = new ArrayList()
boolean answerBoolean = false
def orgIndices = es.search(OrganizationIndex.class, query).data
if (orgIndices.size() == 0) {
    answerLines.add("Нет организаций с кодами RZD/РЖД")
} else if (orgIndices.size() == 1) {
    def index = orgIndices.get(0)
    answerLines.add("Найдена одна организация с кодом ${index.code} (uid=${index.source.uid})")
} else {
    answerBoolean = true
    answerLines.add("Найдено ${orgIndices.size()} организации")
    orgIndices.each {
        answerLines.add("")
        answerLines.add("${it.code} (uid=${it.source.uid})")

        query = new SearchQuery()
        query.criteria.criterions.add(SearchCriterion.eq(RailwayProductIndex.Property.supplier.name(), it.source))
        query.setResultMode(ResultMode.COUNT_ONLY)
        int bookingSupplierCount = es.search(RailwayProductIndex.class, query).totalCount

        query = new SearchQuery()
        query.criteria.criterions.add(SearchCriterion.eq(RailwayProductIndex.Property.blankOwner.name(), it.source))
        query.setResultMode(ResultMode.COUNT_ONLY)
        int bookingBlankOwnerCount = es.search(RailwayProductIndex.class, query).totalCount

        query = new SearchQuery()
        query.criteria.criterions.add(SearchCriterion.eq(RailwayProductIndex.Property.supplier.name(), it.source))
        query.criteria.criterions.add(SearchCriterion.eq(RailwayProductIndex.Property.blankOwner.name(), it.source))
        query.setResultMode(ResultMode.COUNT_ONLY)
        int bookingSupplierAndBlankOwnerCount = es.search(RailwayProductIndex.class, query).totalCount

        query = new SearchQuery()
        query.criteria.criterions.add(SearchCriterion.eq(ContractIndex.Property.supplier.name(), it.source))
        query.setResultMode(ResultMode.COUNT_ONLY)
        int contractSupplierCount = es.search(ContractIndex.class, query).totalCount

        query = new SearchQuery()
        query.criteria.criterions.add(SearchCriterion.eq(ContractIndex.Property.vendor.name(), it.source))
        query.setResultMode(ResultMode.COUNT_ONLY)
        int contractVendorCount = es.search(ContractIndex.class, query).totalCount

        query = new SearchQuery()
        query.criteria.criterions.add(SearchCriterion.eq(ContractIndex.Property.supplier.name(), it.source))
        query.criteria.criterions.add(SearchCriterion.eq(ContractIndex.Property.vendor.name(), it.source))
        query.setResultMode(ResultMode.COUNT_ONLY)
        int contractSupplierAndVendorCount = es.search(ContractIndex.class, query).totalCount

        answerLines.add("Кол-во продуктов с поставщиком: ${bookingSupplierCount}, с ВБ: ${bookingBlankOwnerCount}, с поставщиком и ВБ: ${bookingSupplierAndBlankOwnerCount}")
        answerLines.add("Кол-во контрактов с поставщиком: ${contractSupplierCount}, с ВБ: ${contractVendorCount}, с поставщиком и ВБ: ${contractSupplierAndVendorCount}")
    }
}

answer.booleanData = answerBoolean
answer.textData = answerLines.join("\r\n")

//answerLines.each {message(it)}
