package com.gridnine.xtrip.server.ibecorp.tasks.groovy.xtr13016

import com.gridnine.xtrip.common.model.EntityContainer
import com.gridnine.xtrip.common.model.EntityReference
import com.gridnine.xtrip.common.model.Xeption
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.profile.Organization
import com.gridnine.xtrip.common.model.profile.PersonIndex
import com.gridnine.xtrip.common.model.profile.PersonType
import com.gridnine.xtrip.common.search.ResultMode
import com.gridnine.xtrip.common.search.SearchCriterion
import com.gridnine.xtrip.common.search.SearchQuery
import groovy.transform.Field

//@Field EntityReference<Organization> orgRef = null;
@Field List<EntityReference<Organization>> orgRefs = Arrays.asList(
        new EntityReference<>("3eaf4e67-acab-41a0-b032-397969a11154", Organization.class, null),
        new EntityReference<>("62ea8604-4eae-48c7-a422-a26b103ace35", Organization.class, null),
        new EntityReference<>("4c0a2dc8-2409-4377-b737-c3d9f1b3eac6", Organization.class, null),
        new EntityReference<>("f827c66d-9a39-4f07-9f85-b2f33c38acaa", Organization.class, null),
        new EntityReference<>("de6b7c86-4aa9-4bf0-9120-b96ec0164053", Organization.class, null)
)

orgRefs.each {
    doJob(it);
    message("")
}


void doJob(EntityReference<Organization> orgRef) {
    SearchQuery query = new SearchQuery();
    query.getCriteria().getCriterions().add(
            SearchCriterion.contains(PersonIndex.Property.types.name(), PersonType.PASSENGER));
    query.getCriteria().getCriterions().add(
            SearchCriterion.isEmpty(PersonIndex.Property.englishLastName.name()));
    query.getCriteria().getCriterions().add(
            SearchCriterion.isEmpty(PersonIndex.Property.englishFirstName.name()));

    if (orgRef != null) {
        EntityContainer<Organization> orgCtr = EntityStorage.get().resolve(orgRef);
        if (orgCtr == null) {
            throw Xeption.forEndUser("Невалидная ссылка на организацию {0}", orgRef.getUid());
        }
        message("Фильтр по организации ${orgCtr.getEntity().toString()}");
        query.getCriteria().getCriterions().add(
                SearchCriterion.eq(PersonIndex.Property.company.name(), orgRef));
    }

    query.getPreferredProperties().add("containerUid");

    query.setResultMode(ResultMode.COUNT_ONLY);
    int total = EntityStorage.get().search(PersonIndex.class, query).getTotalCount();

    message("Найдено $total путешественников без латинских фамилии и имени");
}
