import com.gridnine.xtrip.common.model.PassengerPassportIndex
import groovy.transform.Field
import java.text.SimpleDateFormat

@Field String period = parameters['REPORT_PERIOD']

createStyle(name: 'title',fontBold: true, h_span: 14, h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight:20)
createStyle(name: 'header',fontBold: false,  h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight:10,
            leftBorder:'MEDIUM', rightBorder:'MEDIUM', topBorder:'MEDIUM', bottomBorder:'MEDIUM', wrapText: true)
createStyle(name : 'subHeader', fontHeight: 15, parent: 'title')


page { "Пасспорта" } {
    printHeader()
    printTable(allTickets)
}

void printHeader() {
    text('Пасспорта со сроком действия в период ' + period, 'subHeader')
    nextRow()
    rowHeight(25, false)

    text("Клиент", "header")
    columnWidth(15)
    nextColumn()

    text("Имя", "header")
    columnWidth(25)
    nextColumn()

    text("Фамилия", "header")
    columnWidth(25)
    nextColumn()

    text("Отчество", "header")
    columnWidth(25)
    nextColumn()

    text("Тип пасспорта", "header")
    columnWidth(25)
    nextColumn()

    text("Номер пасспорта", "header")
    columnWidth(30)
    nextColumn()

    text("Действителен до", "header")
    columnWidth(20)
    nextColumn()
}

void printTable(List<PassengerPassportIndex> passportIndices) {
    passportIndices.each {PassengerPassportIndex passportIndex ->
        nextRow()
        text(passportIndex.company?.caption, 'textData')
        nextColumn()

        text(passportIndex.firstName, 'textData')
        nextColumn()

        text(passportIndex.middleName, 'textData')
        nextColumn()

        text(passportIndex.lastName, 'textData')
        nextColumn()

        text(passportIndex.passportType.name(), 'textData')
        nextColumn()

        text(passportIndex.passportNumber, 'textData')
        nextColumn()

        text(getDate(passportIndex.expired), 'textData')
        nextColumn()
    }
}

String getDate (Date date) {
    def dateFormat = new SimpleDateFormat('dd.MM.yyyy')
    return date ? dateFormat.format(date) : ''
}