import java.util.Collections

import java.nio.charset.StandardCharsets
import java.nio.file.Files
import java.nio.file.Paths
import java.nio.file.StandardOpenOption

import com.gridnine.xtrip.common.model.EntityContainer
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.profile.Organization
import com.gridnine.xtrip.common.model.profile.OrganizationIndex
import com.gridnine.xtrip.common.model.profile.OrganizationType
import com.gridnine.xtrip.common.search.SearchCriterion
import com.gridnine.xtrip.common.search.SearchQuery

SearchQuery query = new SearchQuery()

List<OrganizationIndex> indexes = EntityStorage.get().search(OrganizationIndex.class, query).getData()

for(OrganizationIndex index : indexes) {

    EntityContainer<Organization> organizationContainer = EntityStorage.get().resolve(index.getSource())

    if(organizationContainer != null) {

        Organization organization = organizationContainer.getEntity();

        if(organization.getFinanceRestrictions().getCreditLimits().size() > 10) {
            Files.write(Paths.get("/tmp/long_credit_limit.txt"), Collections.singleton(String.format("Organization %s has %s credit limits!\n", organizationContainer.toReference(), organization.getFinanceRestrictions().getCreditLimits().size())), StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND);
        }
    }
}