import java.util.Collections

import com.gridnine.xtrip.common.model.EntityContainer
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.profile.Organization
import com.gridnine.xtrip.common.model.profile.OrganizationIndex
import com.gridnine.xtrip.common.model.profile.OrganizationType
import com.gridnine.xtrip.common.search.SearchCriterion
import com.gridnine.xtrip.common.search.SearchQuery

SearchQuery query = new SearchQuery()

List<OrganizationIndex> indexes = EntityStorage.get().search(OrganizationIndex.class, query).getData()

for(OrganizationIndex index : indexes) {

    EntityContainer<Organization> organizationContainer = EntityStorage.get().resolve(index.getSource())

    if(organizationContainer != null) {

        Organization organization = organizationContainer.getEntity()

        if(organization.getFinanceRestrictions().getCreditLimits().size() > 0) {

			organization.getFinanceRestrictions().getCreditLimits().clear()

			organizationContainer.getVersionInfo().setDataSource("delete_organization_credit_limits_task_script")
                    
			EntityStorage.get().save(organizationContainer, true)
        }
    }
}