import com.gridnine.xtrip.common.l10n.model.LocaleHelper
import com.gridnine.xtrip.common.model.EntityReference
import com.gridnine.xtrip.common.model.dict.AddressType
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.helpers.ProfileHelper
import com.gridnine.xtrip.common.model.profile.Address
import com.gridnine.xtrip.common.model.profile.Organization
import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportTicket
import com.gridnine.xtrip.common.util.MiscUtil
import com.gridnine.xtrip.common.util.TextUtil

import java.text.SimpleDateFormat

createStyle(name: "left", h_alignment: "LEFT")
createStyle(name: "right", h_alignment: "RIGHT")
createStyle(name: "center", h_alignment: "CENTER")
createStyle(name: "left-bold", h_alignment: "LEFT", fontBold : true)
createStyle(name: "right-bold", h_alignment: "RIGHT", fontBold : true)
createStyle(name: "center-bold", h_alignment: "CENTER", fontBold : true)
createStyle(name: "center-center", h_alignment: "CENTER", v_alignment: "CENTER")
createStyle(name: "center-center-bold", h_alignment: "CENTER", v_alignment: "CENTER", fontBold : true)
createStyle(name: "center-center-bold-italic", h_alignment: "CENTER", v_alignment: "CENTER", fontBold : true, fontItalic : true)
createStyle(name: "left-center-bold", h_alignment: "LEFT", v_alignment: "CENTER", fontBold : true)
createStyle(name: "left-bold-border", h_alignment: "LEFT", fontBold : true, leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN', wrapText: true)
createStyle(name: "left-center-bold-border", h_alignment: "LEFT", v_alignment: "CENTER", fontBold : true, leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN', wrapText: true)
createStyle(name: "center-center-bold-border", h_alignment: "CENTER", v_alignment: "CENTER", fontBold : true, leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN', foreground : "GREY_40_PERCENT", wrapText: true)
createStyle(name: "right-bold-border", h_alignment: "RIGHT", fontBold : true, leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN', wrapText: true)
createStyle(name: "center-bold-border", h_alignment: "CENTER", fontBold : true, leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN', wrapText: true)
createStyle(name: "left-border", h_alignment: "LEFT", leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN', wrapText: true)
createStyle(name: "right-border", h_alignment: "RIGHT", leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN', wrapText: true)
createStyle(name: "center-border", h_alignment: "CENTER", leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN', wrapText: true)
createStyle(name: "center-center-border", h_alignment: "CENTER", v_alignment: "CENTER", leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN', wrapText: true)
createStyle(name: "center-border-number", format: '0.00', h_alignment: "CENTER", leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN', wrapText: true)
createStyle(name: "center-center-border-number0", format: '0.0', h_alignment: "CENTER", v_alignment: "CENTER", leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN', wrapText: true)
createStyle(name: "center-center-border-number", format: '0.00', h_alignment: "CENTER", v_alignment: "CENTER", leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN', wrapText: true)
createStyle(name: "center-center-bold-border-number", format: '0.00', h_alignment: "CENTER", v_alignment: "CENTER", fontBold : true, leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN', wrapText: true)

def getPeriod() {
    StringBuilder stringBuilder = new StringBuilder();
    Calendar calendar = Calendar.getInstance();
    SimpleDateFormat sdfBegin = new SimpleDateFormat("dd.MM.yyyy")
    SimpleDateFormat sdfEnd = new SimpleDateFormat("dd.MM.yyyy")

    Date periodBeginParameter = parameters['key-report-params']?.periodBegin
    Date periodEndParameter = parameters['key-report-params']?.periodEnd

    Integer yearBegin = MiscUtil.getYear(periodBeginParameter)
    Integer yearEnd = MiscUtil.getYear(periodEndParameter)

    Integer monthBegin = null
    if (periodBeginParameter) {
        calendar.setTime(periodBeginParameter)
        monthBegin = calendar.get(Calendar.MONTH)
    }
    Integer monthEnd = null
    if (periodEndParameter) {
        calendar.setTime(periodEndParameter)
        monthEnd = calendar.get(Calendar.MONTH)
    }

    if (yearBegin == yearEnd) {
        sdfBegin = new SimpleDateFormat("dd.MM")
        if (monthBegin == monthEnd) {
            sdfBegin = new SimpleDateFormat("dd")
        }
    }
    stringBuilder.append(periodBeginParameter ? sdfBegin.format(periodBeginParameter) + " - " : "")
    stringBuilder.append(periodEndParameter ? sdfEnd.format(periodEndParameter) : "")

    return stringBuilder.toString()
}

def printTitle() {
    EntityReference<Organization> agencyParameter = parameters['key-report-params']?.agency
    Organization organization = EntityStorage.get().resolve(agencyParameter)?.entity
    Address address = ProfileHelper.filterAddresses(organization?.getAddresses(), AddressType.LEGAL);

    rowHeight(15)
    nextColumn()

    text("Реестр использования МСО (возврат и перебронирование)", "left-bold", 4, 1)

    nextRow(); nextRow();
    nextColumn(); nextColumn()

    text("АО «Авиакомпания SCAT»", "center-center-bold-italic", 2, 1)

    nextRow(); nextColumn();
    text("Агент:", "left-center-bold")

    nextColumn()
    text(parameters['AGENCY_NAME'], "center-center-bold", 2, 1)

    nextRow(); nextColumn();
    text("На дату:", "left-center-bold")

    nextColumn();
    text(getPeriod(), "center-center-bold", 2, 1)

    nextRow(); nextColumn();
    text("Страна", "left-center-bold")

    nextColumn();
    text(address?.getCountry() ? address.getCountry().toString(LocaleHelper.RU_LOCALE) : "", "center-center-bold-italic", 2, 1)

    nextRow(); nextColumn();
    text("Город", "left-center-bold")

    nextColumn();
    text(address?.getCity() ? address.getCity().toString(LocaleHelper.RU_LOCALE) : "", "center-center-bold-italic", 2, 1)
}

def printHeader() {
    nextRow(); nextRow(); rowHeight(50)

    text("№", "center-center-bold-border")
    nextColumn();text("Номер\nдокумента\n(МСО)")
    nextColumn();text("№ перевозного\nдокумента (БСО)")
    nextColumn();text("Вид услуги\n(перебронирование,\nвозврат, другое)")
    nextColumn();text("Дата\nоперации")
    nextColumn();text("Дата\nвылета")
    nextColumn();text("Номер\nрейса")
    nextColumn();text("Маршрут")
    nextColumn();text("Вид\nтарифа")
    nextColumn();text("Тариф")
    nextColumn();text("Сумма\nсборов")
    nextColumn();text("")
    nextColumn();text("Штрафы и\nпрочие сборы")
    nextColumn();text("% комиссии")
    nextColumn();text("Возврат\nкомиссии")
    nextColumn();text("Итого\nПеревозчику")
}

def printTickets() {
    SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy")
    int i = 0

    tickets { AirTicketsTemplateReportTicket ticket ->
        i++

        nextRow()
        rowHeight(15)

        //"№"
        number(i, "center-center-border")

        //Номер документа (МСО)
        nextColumn()
        text("")

        //№ перевозного документа (БСО)
        nextColumn()
        text((ticket.validatingCarrierNumber ? ticket.validatingCarrierNumber + " " : "") +
                (ticket.ticketNumber ? ticket.ticketNumber : ""))

        //Вид услуги (перебронирование, возврат, другое)
        nextColumn()
        //text(ticket.mcoCategory.toString(LocaleHelper.RU_LOCALE))
        text("Возврат")

        //Дата операции
        nextColumn()
        text(ticket.issueDate ? sdf.format(ticket.issueDate) : "")

        //Дата вылета
        nextColumn()
        text(ticket.departureDate ? sdf.format(ticket.departureDate) : "")

        //Номер рейса
        nextColumn()
        text(TextUtil.join(", ", new LinkedHashSet(ticket.flightNumbers)))

        //Маршрут
        nextColumn()
        text(ticket.routeLine)

        //Вид тарифа
        nextColumn()
        //text(ticket.tariffType.toString(LocaleHelper.RU_LOCALE))
        text(ticket.tariffCodes)

        //Тариф
        nextColumn()
        def equivalentFare = ticket.equivalentFare ? ticket.equivalentFare : BigDecimal.ZERO
        number(equivalentFare, "center-center-border-number")

        //Сумма сборов
        nextColumn()
        def taxesSum = ticket.taxesSum ? ticket.taxesSum : BigDecimal.ZERO
        number(taxesSum, "center-center-border-number")

        //""
        nextColumn()
        text("")

        //Штрафы и прочие сборы
        nextColumn()
        number(ticket.penalty ? ticket.penalty : BigDecimal.ZERO, "center-center-border-number")

        //% комиссии
        nextColumn()
        number(ticket.vendorCommissionRate ? ticket.vendorCommissionRate : BigDecimal.ZERO
                , "center-center-border-number0")

        //Возврат комиссии
        nextColumn()
        number(ticket.vendorCommissionValue ? ticket.vendorCommissionValue : BigDecimal.ZERO,
                "center-center-border-number")

        //Итого перевозчику
        nextColumn()
        formula("-${cellIndex(0, -6)}-${cellIndex(0, -5)}+${cellIndex(0, -3)}+${cellIndex(0, -1)}"
                , "center-center-border-number")
    }

    nextRow()
    text("Итого по реестру:", "left-center-bold-border", 9, 1)

    9.times {
        nextColumn()
        text("", "left-center-bold-border")
    }

    //Итого - тариф
    if (count() > 0) {
        formula("SUM(${cellIndex(-count(), 0)}:${cellIndex(-1, 0)})", "center-center-bold-border-number")
    } else {
        number(BigDecimal.ZERO, "center-center-bold-border-number")
    }

    //Итого - Сумма сборов
    nextColumn()
    if (count() > 0) {
        formula("SUM(${cellIndex(-count(), 0)}:${cellIndex(-1, 0)})", "center-center-bold-border-number")
    } else {
        number(BigDecimal.ZERO, "center-center-bold-border-number")
    }

    nextColumn()
    text("", "left-center-bold-border")

    //Итого - Штрафы и прочие сборы
    nextColumn()
    if (count() > 0) {
        formula("SUM(${cellIndex(-count(), 0)}:${cellIndex(-1, 0)})", "center-center-bold-border-number")
    } else {
        number(BigDecimal.ZERO, "center-center-bold-border-number")
    }

    nextColumn()
    text("", "left-center-bold-border")

    //Итого - Возврат комиссии
    nextColumn()
    if (count() > 0) {
        formula("SUM(${cellIndex(-count(), 0)}:${cellIndex(-1, 0)})", "center-center-bold-border-number")
    } else {
        number(BigDecimal.ZERO, "center-center-bold-border-number")
    }

    //Итого Перевозчику
    nextColumn()
    if (count() > 0) {
        formula("SUM(${cellIndex(-count(), 0)}:${cellIndex(-1, 0)})", "center-center-bold-border-number")
    } else {
        number(BigDecimal.ZERO, "center-center-bold-border-number")
    }

}

def setAutoWidth() {
    nextRow()
    rowAutoHeight()

    columnAutoWidth()
    16.times {
        nextColumn()
        columnAutoWidth()
    }
}

page{"ВОЗВРАТ " + getPeriod()} {
    printTitle()
    printHeader()
    printTickets()
    setAutoWidth()
}
