// Imports

import com.gridnine.xtrip.common.l10n.model.LocaleHelper
import com.gridnine.xtrip.common.model.dict.AddressType
import com.gridnine.xtrip.common.model.dict.CodeSystem
import com.gridnine.xtrip.common.model.dict.GdsName
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.helpers.DictHelper
import com.gridnine.xtrip.common.model.helpers.PersonalLocalizableNameFormatter
import com.gridnine.xtrip.common.model.helpers.ProfileHelper

import java.text.SimpleDateFormat

// Styles
createStyle(name: 'title', h_alignment: 'CENTER', v_alignment: 'CENTER')
createStyle(name: 'titleH1', fontHeight: 12, parent: 'title')
createStyle(name: 'titleH2', fontHeight: 10, parent: 'title')
createStyle(name: 'header', h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight: 8)
createStyle(name: 'columnHeader', h_alignment: 'LEFT', parent: 'header')
createStyle(name: 'rowHeader', parent: 'header')
createStyle(name: 'data', h_alignment: 'LEFT', v_alignment: 'CENTER', fontHeight: 8)
createStyle(name: 'dataText', parent: 'data')
createStyle(name: 'dataDate', format: 'm/d/yy', parent: 'data')
createStyle(name: 'dataNumber', h_alignment: 'RIGHT', parent: 'data')
createStyle(name: 'dataSum', format: '#,##0.00', parent: 'dataNumber')
createStyle(name: 'wrap', wrapText: true)
createStyle(name: 'ahl', h_alignment: 'LEFT')
createStyle(name: 'ahc', h_alignment: 'CENTER')
createStyle(name: 'ahr', h_alignment: 'RIGHT')
createStyle(name: 'avt', v_alignment: 'TOP')
createStyle(name: 'avc', v_alignment: 'CENTER')
createStyle(name: 'avb', v_alignment: 'BOTTOM')
createStyle(name: 'aac', h_alignment: 'CENTER', v_alignment: 'CENTER')
createStyle(name: 'bold', fontBold: true)
createStyle(name: 'italic', fontItalic: true)
createStyle(name: 'bt', topBorder: 'THIN')
createStyle(name: 'bl', leftBorder: 'THIN')
createStyle(name: 'bb', bottomBorder: 'THIN')
createStyle(name: 'br', rightBorder: 'THIN')
createStyle(name: 'ba', topBorder: 'THIN', leftBorder: 'THIN', bottomBorder: 'THIN', rightBorder: 'THIN')

// Closures
def period = {
    SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy")
    def periodBeginParameter = parameters['key-report-params']?.periodBegin
    def periodEndParameter = parameters['key-report-params']?.periodEnd
    return "Период с " +
            (periodBeginParameter ? sdf.format(periodBeginParameter) : "") +
            " по " +
            (periodEndParameter ? sdf.format(periodEndParameter) : "")
}

def agencyName = {
    def organization = EntityStorage.get().resolve(parameters['key-report-params']?.agency)?.entity
    return organization ? ProfileHelper.getFullName(organization, LocaleHelper.getLocale('ru', 'RU'), false) : 'Не указано'
}

def accountantName = {
    def person = EntityStorage.get().resolve(requestedParameter('accountant'))?.entity
    def format = new PersonalLocalizableNameFormatter(PersonalLocalizableNameFormatter.SIMPLE)
    return person ? format.format(person, LocaleHelper.getLocale('ru', 'RU'), false) : '?'
}

//Functions
def cashierPersonalNumber(agent) {
    def result = 'Не указано'
    def cashier = EntityStorage.get().resolve(agent)?.entity
    if (cashier != null) {
        cashier.getGdsReferences().each {
            if (it.getGdsName() == GdsName.SIRENA)
                result = it.getReference()
        }
    }
    return result
}

def salesPointCity(salesPoint) {
    def result = 'Не указано'
    def sp = EntityStorage.get().resolve(salesPoint)?.entity
    if (sp != null) {
        sp.getAddresses().each {
            if (it.getAddressType() == AddressType.FACTUAL)
                result = it.getCity().toString()
        }
    }
    return result
}

page { 'Билеты ВПД для МО, Аврора' } {

    // Set landscape mode
    landscape(true)

    // Set narrow margins
    margin(0.25, 0.25, 0.75, 0.75)

    // Set scale
    scale(100)

    // Set preserve mode
    preserve(false)

// Report header
    text('Агентство: ', 'titleH2|ahl', 2, 1)
    2.times { nextColumn() }
    text(agencyName(), 'titleH2|ahl')
    nextRow()
    text('Организация - клиент: МИНИСТЕРСТВО ОБОРОНЫ РФ', 'titleH2|ahl')
    5.times { nextColumn() }
    text(period(), 'titleH2|ahl')
    nextRow()
    text('Вид оплаты: КР', 'titleH2|ahl')
    nextRow()
    text('Валюта: RUB', 'titleH2|ahl')
    3.times { nextColumn() }
    text('ВВЛ', 'titleH2|ahl')
    nextRow()
    text('Перевозчик: а/к "Аврора"', 'titleH2|ahl')
    nextRow()

// Table header
    text('№ п/п', 'columnHeader|wrap|ba')
    nextColumn()
    text('Личный номер кассира', 'columnHeader|wrap|ba')
    nextColumn()
    text('Пункт оформления', 'columnHeader|wrap|ba')
    nextColumn()
    text('Серия, номер перевозочного документа', 'columnHeader|wrap|ba')
    nextColumn()
    text('Серия, номер воинского требования', 'columnHeader|wrap|ba')
    nextColumn()
    text('Дата оформления перевозочного документа', 'columnHeader|wrap|ba')
    nextColumn()
    text('Дата перевозки по перевозочному документу', 'columnHeader|wrap|ba')
    nextColumn()
    text('Перевозчик (код)', 'columnHeader|wrap|ba')
    nextColumn()
    text('Номер рейса', 'columnHeader|wrap|ba')
    nextColumn()
    text('Аэропорт отправления', 'columnHeader|wrap|ba')
    nextColumn()
    text('Аэропорт назначения', 'columnHeader|wrap|ba')
    nextColumn()
    text('Фамилия, имя, отчество', 'columnHeader|wrap|ba')
    nextColumn()
    text('Наименование, серия, номер документа удостоверяющего личность', 'columnHeader|wrap|ba')
    nextColumn()
    text('Вид тарифа', 'columnHeader|wrap|ba')
    nextColumn()
    text('Сумма к оплате', 'columnHeader|wrap|ba')
    nextColumn()
    text('Корректировка суммы', 'columnHeader|wrap|ba')
    nextColumn()
    text('Основание корректировки', 'columnHeader|wrap|ba')
    rowHeight(80)
    nextRow()

// Table
    int counter = 0
    int counterMTD = 0

    tickets {
        number(++counter, 'dataText|ba')
        nextColumn()
        text(cashierPersonalNumber(it.getAgent()), 'dataText|ba')
        nextColumn()
        text(salesPointCity(it.getSalesPoint()), 'dataText|ba')
        nextColumn()
        text((it.validatingCarrierNumber ? it.validatingCarrierNumber + " " : "") +
                (it.ticketNumber ? it.ticketNumber : ""), 'dataText|ba')
        nextColumn()
        text(it.relatedDocumentNumber, 'dataText|ba')
        nextColumn()
        date(it.issueDate, 'dataDate|ba')
        nextColumn()
        date(it.departureDate, 'dataDate|ba|ahr')
        nextColumn()
        text('ИЕ', 'dataText|ba|ahc')
        nextColumn()
        text(it.flightNumbers.get(0), 'dataText|ba')
        nextColumn()
        text(it.departureLocationCodes[CodeSystem.CRT.name()], 'dataText|ba')
        nextColumn()
        text(it.arriveLocationCodes[CodeSystem.CRT.name()], 'dataText|ba')
        nextColumn()
        text(it.travellerName, 'dataText|ba')
        nextColumn()
        text(it.travellerPassportNumber, 'dataText|ba')
        nextColumn()
        text(it.fareBasisLine, 'dataText|ba')
        nextColumn()
        number(it.price, 'dataNumber|ba')
        nextColumn()
        text('', 'dataText|ba')
        nextColumn()
        text('', 'dataText|ba')
        nextColumn()
        nextRow()

        if (it.fareBasisLine.equals("ZDVO")) counterMTD++
    }

    11.times {
        text('', 'dataText|ba')
        nextColumn()
    }
    text('Итого:', 'dataText|ba|ahl')
    3.times {
        nextColumn()
        text('', 'dataText|ba')
    }
    formula("SUM(O7:${cellIndex(-1, 0)})", 'dataSum|ba')
    2.times {
        nextColumn()
        text('', 'dataText|ba')
    }

    2.times { nextRow() }
    nextColumn()
    text('ВПД ' + counterMTD + ' шт.', 'dataText')

    2.times { nextColumn() }
    text('Бухгалтер:', 'titleH2|ahr')
    2.times {
        nextColumn()
        text('', 'bb')
    }
    nextColumn()
    text(accountantName(), 'titleH2|ahl')

    //Setup columns width
    nextRow()
    columnWidth(3)
    nextColumn()
    columnWidth(8)
    nextColumn()
    columnWidth(12)
    nextColumn()
    2.times {
        columnWidth(14)
        nextColumn()
    }
    2.times {
        columnWidth(9)
        nextColumn()
    }
    4.times {
        columnWidth(5)
        nextColumn()
    }
    columnWidth(25)
    nextColumn()
    columnWidth(13)
    nextColumn()
    2.times {
        columnWidth(8)
        nextColumn()
    }
    2.times {
        columnWidth(6)
        nextColumn()
    }

}