// Imports


import com.gridnine.xtrip.common.l10n.model.LocaleHelper
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.helpers.PersonalLocalizableNameFormatter

import java.text.SimpleDateFormat

// Styles
createStyle(name: 'title', h_alignment: 'CENTER', v_alignment: 'CENTER')
createStyle(name: 'titleH1', fontHeight: 12, parent: 'title')
createStyle(name: 'data', h_alignment: 'LEFT', v_alignment: 'CENTER', fontHeight: 10)
createStyle(name: 'dataText', parent: 'data')
createStyle(name: 'wrap', wrapText: true)
createStyle(name: 'ahl', h_alignment: 'LEFT')
createStyle(name: 'ahc', h_alignment: 'CENTER')
createStyle(name: 'ahr', h_alignment: 'RIGHT')
createStyle(name: 'avt', v_alignment: 'TOP')
createStyle(name: 'avc', v_alignment: 'CENTER')
createStyle(name: 'avb', v_alignment: 'BOTTOM')
createStyle(name: 'aac', h_alignment: 'CENTER', v_alignment: 'CENTER')
createStyle(name: 'bold', fontBold: true)

// Closures
def period = {
    SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy")
    def periodBeginParameter = parameters['key-report-params']?.periodBegin
    def periodEndParameter = parameters['key-report-params']?.periodEnd
    return "за период с " +
            (periodBeginParameter ? sdf.format(periodBeginParameter) : "") +
            " по " +
            (periodEndParameter ? sdf.format(periodEndParameter) : "")
}

def accountantName = {
    def person = EntityStorage.get().resolve(requestedParameter('accountant'))?.entity
    def format = new PersonalLocalizableNameFormatter(PersonalLocalizableNameFormatter.SIMPLE)
    return person ? format.format(person, LocaleHelper.getLocale('ru', 'RU'), false) : '?'
}

def signMonth = {
    SimpleDateFormat sdf = new SimpleDateFormat("MMMM yyyy")
    def periodEndParameter = parameters['key-report-params']?.periodEnd
    return periodEndParameter ? sdf.format(periodEndParameter) + " г." : ""
}

//Vars
def signatureLine = '______________________'

page { 'Реестр о передаче отчета о продаже авиаперевозок по ВПД МО на рейсах авиакомпании «Аврора»' } {

    // Set portrait mode
    landscape(false)

    // Set narrow margins
    margin(0.25, 0.25, 0.75, 0.75)

    // Set scale
    scale(100)

    // Set preserve mode
    preserve(false)

// Report
    text('Реестр о передаче отчета о продаже авиаперевозок по ВПД МО на рейсах  авиакомпании «Аврора»', 'titleH1|wrap|bold', 7, 1)
    rowHeight(40)
    2.times { nextRow() }
    text(period(), 'titleH1|bold', 7, 1)
    rowHeight(15)
    4.times { nextRow() }
    text('Сдал документы', 'dataText', 2, 1)
    4.times { nextColumn() }
    text(accountantName() + ' ' + signatureLine, 'dataText', 3, 1)
    nextRow()
    text('Исх. №', 'dataText')
    4.times { nextColumn() }
    text("«____» " + signMonth(), 'dataText', 2, 1)
    2.times {nextRow()}
    text('Принял документы', 'dataText', 2, 1)
    4.times { nextColumn() }
    text('Представитель авиакомпании:', 'dataText', 3, 1)
    nextRow()
    4.times { nextColumn() }
    text(signatureLine + signatureLine, 'dataText', 3, 1)
    nextRow()
    4.times { nextColumn() }
    text(signatureLine + 'Ф.И.О.(полностью)', 'dataText', 3, 1)
    nextRow()
    4.times { nextColumn() }
    text("«____» " + signMonth(), 'dataText', 3, 1)

    nextRow()
    5.times { nextColumn() }
    columnWidth(15)

}