import com.gridnine.xtrip.common.l10n.model.LocaleHelper
import com.gridnine.xtrip.common.model.system.PaymentType
import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportTicket
import com.gridnine.xtrip.common.util.TextUtil

import java.text.SimpleDateFormat

createStyle(name: "left", h_alignment: "LEFT")
createStyle(name: "right", h_alignment: "RIGHT")
createStyle(name: "center", h_alignment: "CENTER")
createStyle(name: "left-bold", h_alignment: "LEFT", fontBold : true)
createStyle(name: "right-bold", h_alignment: "RIGHT", fontBold : true)
createStyle(name: "center-bold", h_alignment: "CENTER", fontBold : true)
createStyle(name: "center-center", h_alignment: "CENTER", v_alignment: "CENTER")
createStyle(name: "center-center-bold", h_alignment: "CENTER", v_alignment: "CENTER", fontBold : true)
createStyle(name: "left-bold-border", h_alignment: "LEFT", fontBold : true, leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN', wrapText: true)
createStyle(name: "left-center-bold-border", h_alignment: "LEFT", v_alignment: "CENTER", fontBold : true, leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN', wrapText: true)
createStyle(name: "right-bold-border", h_alignment: "RIGHT", fontBold : true, leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN', wrapText: true)
createStyle(name: "center-bold-border", h_alignment: "CENTER", fontBold : true, leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN', wrapText: true)
createStyle(name: "left-border", h_alignment: "LEFT", leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN', wrapText: true)
createStyle(name: "right-border", h_alignment: "RIGHT", leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN', wrapText: true)
createStyle(name: "center-border", h_alignment: "CENTER", leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN', wrapText: true)
createStyle(name: "center-center-border", h_alignment: "CENTER", v_alignment: "CENTER", leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN', wrapText: true)
createStyle(name: "center-border-number", format: '0.00', h_alignment: "CENTER", leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN', wrapText: true)
createStyle(name: "center-center-border-number", format: '0.00', h_alignment: "CENTER", v_alignment: "CENTER", leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN', wrapText: true)

def printHead() {
    rowHeight(30)
    columnWidth(2)

    nextRow()
    rowHeight(30)
    10.times {
        nextColumn()
    }
    text("Форма №4", "center-center-bold", 4, 1)
}

def printTitle() {
    nextRow(); rowHeight(15)
    nextRow(); nextColumn()

    text("Реестр обмена авиабилетов", "center-center-bold", 14, 1)

    nextRow(); nextColumn()

    SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy г.")
    def periodBeginParameter = parameters['key-report-params']?.periodBegin
    def periodEndParameter = parameters['key-report-params']?.periodEnd

    text("За период с " +
            (periodBeginParameter ? sdf.format(periodBeginParameter) : "") +
            " по " +
            (periodEndParameter ? sdf.format(periodEndParameter) : ""),
            "center-center", 14, 1)
}

def printHeader() {
    nextRow(); nextRow(); rowHeight(60)

    nextColumn();text("№" + "\n" + "п/п", "center-center-border")
    nextColumn();text("№ принятого к" + "\n" + "обмену" + "\n" + "авиабилета")
    nextColumn();text("Дата оформления" + "\n" + "принятого к" + "\n" + "обмену" + "\n" + "авиабилета")
    nextColumn();text("Номер рейса")
    nextColumn();text("Дата вылета")
    nextColumn();text("Маршрут")
    nextColumn();text("Тариф")
    nextColumn();text("Код тарифа" + "\n" + "принятого к" + "\n" + "обмену" + "\n" + "авиабилета")
    nextColumn();text("№ выданного" + "\n" + "в обмен" + "\n" + "авиабилета")
    nextColumn();text("Доплата по тарифу")
    nextColumn();text("Код тарифа" + "\n" + "выданного" + "\n" + "в обмен" + "\n" + "авиабилета")
    nextColumn();text("Сбор за обмен")
    nextColumn();text("Другие сборы")
    nextColumn();text("Форма оплаты")
}

def printTickets() {
    int i = 0

    SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy")

    tickets { AirTicketsTemplateReportTicket ticket ->
        i++

        nextRow(); rowHeight(15)

        nextColumn()
        number(i, "center-center-border")

        nextColumn()
        text((ticket.relatedTicketValidatingCarrierNumber ? ticket.relatedTicketValidatingCarrierNumber + " " : "") +
                (ticket.relatedTicketNumber ? ticket.relatedTicketNumber : ""))

        nextColumn()
        text(ticket.relatedTicketIssueDate ? sdf.format(ticket.relatedTicketIssueDate) : "")

        nextColumn()
        text(TextUtil.join(", ", new LinkedHashSet(ticket.flightNumbers)))

        nextColumn()
        text(ticket.departureDate ? sdf.format(ticket.departureDate) : "")

        nextColumn()
        text(ticket.crtRouteLine)

        nextColumn()
        number(ticket.equivalentFareBeforeExchange ? ticket.equivalentFareBeforeExchange : BigDecimal.ZERO, "center-center-border-number")

        nextColumn()
        text(ticket.relatedTicketFareBasisLine ? ticket.relatedTicketFareBasisLine : "", "center-center-border")

        nextColumn()
        text((ticket.validatingCarrierNumber ? ticket.validatingCarrierNumber + " " : "") +
                (ticket.ticketNumber ? ticket.ticketNumber : ""))

        nextColumn()
        number(ticket.equivalentFare ? ticket.equivalentFare : BigDecimal.ZERO, "center-center-border-number")

        nextColumn()
        text(ticket.fareBasisLine ? ticket.fareBasisLine : "", "center-center-border")

        nextColumn()
        number(ticket.penalty ? ticket.penalty : BigDecimal.ZERO, "center-center-border-number")

        nextColumn()
        number(ticket.taxesSum ? ticket.taxesSum : BigDecimal.ZERO, "center-center-border-number")

        nextColumn()
        Set<String> paymentTypes = new LinkedHashSet<>()
        for (PaymentType type : ticket.paymentTypes) {
            if (type != null && type != PaymentType.TICKET) {
                paymentTypes.add(type.toString(LocaleHelper.RU_LOCALE))
            }
        }
        text(TextUtil.join(", ", paymentTypes), "center-center-border")
    }

    nextRow()
    nextColumn()
    text("Итого:", "left-center-bold-border", 6, 1)

    5.times {
        nextColumn()
    }

    if (count() > 0) {
        nextColumn()
        formula("SUM(${cellIndex(-count(), 0)}:${cellIndex(-1, 0)})", "center-center-border-number")
    } else {
        number(BigDecimal.ZERO, "center-center-border-number")
    }

    2.times {
        nextColumn()
        text("")
    }

    if (count() > 0) {
        nextColumn()
        formula("SUM(${cellIndex(-count(), 0)}:${cellIndex(-1, 0)})", "center-center-border-number")
    } else {
        number(BigDecimal.ZERO, "center-center-border-number")
    }

    nextColumn()
    text("")

    2.times {
        nextColumn()
        if (count() > 0) {
            formula("SUM(${cellIndex(-count(), 0)}:${cellIndex(-1, 0)})", "center-center-border-number")
        } else {
            number(BigDecimal.ZERO, "center-center-border-number")
        }
    }

    nextColumn()
    text("")
}

def printAccountant() {
    nextRow(); rowHeight(60)
    nextRow(); nextColumn(); nextColumn(); rowHeight(60)
    text("Главный бухгалтер ___________________________", "left", 4, 1)
}

def setAutoWidth() {
    nextRow()
    rowAutoHeight()

    14.times {
        nextColumn()
        columnAutoWidth()
    }
}

page{"Реестр обмена авиабилетов"} {
    printHead()
    printTitle()
    printHeader()
    printTickets()
    printAccountant()
    setAutoWidth()
}