import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportTicket
import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportTicketType
import com.gridnine.xtrip.server.reports.prepare.salesreports.nn.NNAdmReportTicket;
import com.gridnine.xtrip.server.reports.prepare.salesreports.nn.NNReportHelper;
import com.gridnine.xtrip.server.reports.prepare.salesreports.nn.NNSellReportTicket;
import com.gridnine.xtrip.server.reports.prepare.salesreports.nn.NNTransportationType
import com.gridnine.xtrip.server.reports.prepare.salesreports.nn.NNVoidReportTicket;
import com.gridnine.xtrip.server.reports.salesreports.render.nn.NNReportTestBase;;

//CREATING STYLES
createStyle(name: 'title',fontBold: true, h_span: 8, h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight:15)
createStyle(name: 'subTitleLabel',fontBold: true, h_span: 2, h_alignment: 'RIGHT', v_alignment: 'CENTER', fontHeight:10)
createStyle(name: 'subTitleData',fontBold: false,  h_alignment: 'LEFT', v_alignment: 'CENTER', fontHeight:10)
createStyle(name: 'header',fontBold: false,  h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight:10, leftBorder:'MEDIUM', rightBorder:'MEDIUM', topBorder:'MEDIUM', bottomBorder:'MEDIUM', wrapText: true)
createStyle(name: 'data',fontBold: false,  h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight:10, leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN')
createStyle(name: 'textData',parent: 'data')
createStyle(name: 'numberData',parent: 'data',h_alignment: 'RIGHT')
createStyle(name: 'dateData',parent: 'data',h_alignment: 'RIGHT',format: 'm/d/yy')
createStyle(name: 'totalTitle', parent: 'header', h_span: 2, h_alignment: 'LEFT', fontBold: true)
createStyle(name: 'totalTitleSpan4', parent: 'totalTitle', h_span: 4)
createStyle(name: 'totalNumber',parent: 'totalTitle',  h_span: 1)

def tickets = []
allTickets.each { AirTicketsTemplateReportTicket ticket ->
    if(ticket.type == AirTicketsTemplateReportTicketType.MEMO) {
        tickets << new NNAdmReportTicket(ticket)
    }
}

//REPORT
page{"Реестр по претензиям"}{
    //title
    rowHeight(30)
    text("Реестр расшифровка расчетов по претензионным уведомлениям",'title')
    nextRow()
    nextRow()
    //header
    rowHeight(40);
    setStyle('header')
    columnWidth(15)
    text('Номер П/П');nextColumn();
    columnWidth(15)
    text('Исх. № ');nextColumn();
    columnWidth(15)
    text('Номер Претензии');nextColumn();
    columnWidth(12)
    text('Дата получения');nextColumn();
    columnWidth(10)
    text('Сумма претензии');nextColumn();
    columnWidth(10)
    text('Сумма принятая');nextColumn();
    columnWidth(15)
    text('Исх. № ответа на претензию');nextColumn();
    columnWidth(12)
    text('Дата ответа по претензии');
    def rowCount = 0;
    tickets.each {NNAdmReportTicket ticket ->
        rowCount++
        nextRow()
        rowHeight(15)
        text(ticket.ppNumber, 'textData');nextColumn();
        text(ticket.outgoingNumber, 'textData');nextColumn();
        text(ticket.admNumber, 'textData');nextColumn();
        date(ticket.recieved, 'dateData');nextColumn();
        number(ticket.admSum, 'numberData');nextColumn();
        number(ticket.submitedSum, 'numberData');nextColumn();
        text(ticket.outgoingResponseNumber, 'textData');nextColumn();
        date(ticket.responseDate, 'dateData');
    }
    nextRow();
    rowHeight(15)
    text("Итого выставлено", 'totalTitle');
    nextColumn();
    text(null, 'totalTitleSpan4');
    nextColumn();
    text("Итого оплачено", 'totalTitle');
    nextRow()
    rowHeight(12)
    nextRow()
    text("Исполнил", 'subTitleLabel');
    nextRow()
    nextRow()
    text("Подпись", 'subTitleLabel');
}

