import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportTicket
import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportTicketType
import com.gridnine.xtrip.server.reports.prepare.salesreports.nn.NNExchangeReportTicket;
import com.gridnine.xtrip.server.reports.prepare.salesreports.nn.NNReportHelper;
import com.gridnine.xtrip.server.reports.prepare.salesreports.nn.NNSellReportTicket;
import com.gridnine.xtrip.server.reports.prepare.salesreports.nn.NNTransportationType
import com.gridnine.xtrip.server.reports.salesreports.render.nn.NNReportTestBase;;

//CREATING STYLES
createStyle(name: 'title',fontBold: true, h_span: 16, h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight:20)
createStyle(name: 'subTitleLabel',fontBold: true, h_span: 2, h_alignment: 'RIGHT', v_alignment: 'CENTER', fontHeight:10)
createStyle(name: 'subTitleData',fontBold: false,  h_alignment: 'LEFT', v_alignment: 'CENTER', fontHeight:10)
createStyle(name: 'header',fontBold: false,  h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight:10, leftBorder:'MEDIUM', rightBorder:'MEDIUM', topBorder:'MEDIUM', bottomBorder:'MEDIUM', wrapText: true)
createStyle(name: 'data',fontBold: false,  h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight:10, leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN')
createStyle(name: 'textData',parent: 'data')
createStyle(name: 'numberData',parent: 'data',h_alignment: 'RIGHT')
createStyle(name: 'dateData',parent: 'data',h_alignment: 'RIGHT',format: 'm/d/yy')
createStyle(name: 'totalTitle', parent: 'header', h_span: 9, h_alignment: 'RIGHT', fontBold: true)
createStyle(name: 'totalNumber',parent: 'totalTitle',  h_span: 1)



NNTransportationType transportationType = NNTransportationType.valueOf(parameters['transportationType'])
def tickets = []
allTickets.each { AirTicketsTemplateReportTicket ticket ->
    if(ticket.type == AirTicketsTemplateReportTicketType.MEMO) {
        return;
    }
    NNTransportationType tt = NNReportHelper.getTransportationType(ticket)
    if(tt != transportationType) {
        return;
    } 
    tickets.addAll(NNExchangeReportTicket.createExchangeTickets(ticket))
}

def title(NNTransportationType transportationType) {
    if(transportationType == NNTransportationType.VVL) {
        return "Обмен ВВЛ"
    }
    if(transportationType == NNTransportationType.MVL) {
        return "Обмен МВЛ"
    }
    return "Обмен Крым"
}

def footer = {
    nextRow()
    rowHeight(12)
    nextRow()
    text("Исполнил", 'subTitleLabel');
    nextRow()
    nextRow()
    text("Подпись", 'subTitleLabel');
}
//REPORT
page{parameters['title']}{
    //title
    rowHeight(30)
    text(title(transportationType),'title')
    nextRow()
    nextRow()
    rowHeight(15)
    text("Субагент", 'subTitleLabel')
    nextColumn()
    text(parameters['AGENCY_NAME'], 'subTitleData')
    nextRow()
    text("Период",'subTitleLabel')
    nextColumn()
    text(parameters['REPORT_PERIOD'], 'subTitleData')
    //header
    nextRow()
    nextRow()
    rowHeight(40);
    setStyle('header')
    text('Вид');nextColumn();
    columnWidth(20);
    text('Номер БПД выдан в обмен');nextColumn();
    columnWidth(20);
    text('Номер БПД принят к обмену');nextColumn();
    columnWidth(12);
    text('Дата обмена');nextColumn();
    columnWidth(12);
    text('Дата продажи обм. билета');nextColumn();
    columnWidth(10);
    text('Номер рейса по билету');nextColumn();
    columnWidth(20);
    text('Маршрут');nextColumn();
    columnWidth(10);
    text('Дата вылета');nextColumn();
    text('Вид тарифа/класс бронир.');nextColumn();
    text('Тариф');nextColumn();
    text('Топливный сбор');nextColumn();
    text('Сбор за бланк (обмен)');nextColumn();
    text('% ком.вознаграждения');nextColumn();
    text('Сумма ком.вознаграждения');nextColumn();
    text('Штраф');nextColumn();
    text('код агентства');
    int rowCount = 0;
    tickets.each {NNExchangeReportTicket ticket ->
        nextRow()
        rowHeight(15)
        text(ticket.type.toString(), 'textData');nextColumn();
        text(ticket.bpdNumer, 'textData');nextColumn();
        text(ticket.firstSellNumber, 'textData');nextColumn();
        date(ticket.operationDate, 'dateData');nextColumn();
        date(ticket.firstSellIssueDate, 'dateData');nextColumn();
        text(ticket.flightNumber, 'textData');nextColumn();
        text(ticket.airport, 'textData');nextColumn();
        date(ticket.departureDate, 'dateData');nextColumn();
        text(ticket.fareBasis, 'textData');nextColumn();
        number(ticket.equivalentFare, 'numberData');nextColumn();
        number(ticket.taxForFuel, 'numberData');nextColumn();
        number(ticket.taxForBlank, 'numberData');nextColumn();
        number(ticket.commissionRate, 'numberData');nextColumn();
        number(ticket.commissionValue, 'numberData');nextColumn();
        number(ticket.penalty, 'numberData');nextColumn();
        text(ticket.agencyCode, 'textData');
        rowCount++
    }
    nextRow();
    if(rowCount >0) {
        text("Итого", 'totalTitle');
        nextColumn()
        formula("SUM(J7:J${6+rowCount})", 'totalNumber')
        nextColumn()
        formula("SUM(K7:K${6+rowCount})", 'totalNumber')
        nextColumn()
        formula("SUM(L7:L${6+rowCount})", 'totalNumber')
        nextColumn()
        number(null, 'totalNumber')
        nextColumn()
        formula("SUM(N7:N${6+rowCount})", 'totalNumber')
        nextColumn()
        formula("SUM(O7:O${6+rowCount})", 'totalNumber')
        nextColumn()
        number(null, 'totalNumber')
        footer()
        return
    }
    rowHeight(15)
    text("Итого", 'totalTitle');
    nextColumn()
    number(null, 'totalNumber')
    nextColumn()
    number(null, 'totalNumber')
    nextColumn()
    number(null, 'totalNumber')
    nextColumn()
    number(null, 'totalNumber')
    nextColumn()
    number(null, 'totalNumber')
    nextColumn()
    number(null, 'totalNumber')
    nextColumn()
    number(null, 'totalNumber')
    footer();
}

